/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

public abstract class AbstractGenericUDFReflect
extends GenericUDF {
    private PrimitiveObjectInspector[] parameterOIs;
    private PrimitiveObjectInspectorUtils.PrimitiveTypeEntry[] parameterTypes;
    private Class[] parameterClasses;
    private Object[] parameterJavaValues;

    void setupParameterOIs(ObjectInspector[] arguments, int start) throws UDFArgumentTypeException {
        int length = arguments.length - start;
        this.parameterOIs = new PrimitiveObjectInspector[length];
        this.parameterTypes = new PrimitiveObjectInspectorUtils.PrimitiveTypeEntry[length];
        this.parameterClasses = new Class[length];
        this.parameterJavaValues = new Object[length];
        for (int i = 0; i < length; ++i) {
            if (arguments[i + start].getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UDFArgumentTypeException(i, "The parameters of GenericUDFReflect(class,method[,arg1[,arg2]...]) must be primitive (int, double, string, etc).");
            }
            this.parameterOIs[i] = (PrimitiveObjectInspector)arguments[i + start];
            this.parameterTypes[i] = PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveCategory(this.parameterOIs[i].getPrimitiveCategory());
            this.parameterClasses[i] = this.parameterTypes[i].primitiveJavaType == null ? this.parameterTypes[i].primitiveJavaClass : this.parameterTypes[i].primitiveJavaType;
        }
    }

    Object[] setupParameters(GenericUDF.DeferredObject[] arguments, int start) throws HiveException {
        for (int i = 0; i < this.parameterOIs.length; ++i) {
            Object argument = arguments[i + start].get();
            this.parameterJavaValues[i] = this.parameterOIs[i].getPrimitiveJavaObject(argument);
        }
        return this.parameterJavaValues;
    }

    Method findMethod(Class clazz, String name, Class<?> retType, boolean memberOnly) throws Exception {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name) || retType != null && !retType.isAssignableFrom(method.getReturnType()) || memberOnly && Modifier.isStatic(method.getReturnType().getModifiers()) || method.getParameterTypes().length != this.parameterTypes.length) continue;
            boolean match = true;
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                if (types[i] == this.parameterTypes[i].primitiveJavaType || types[i] == this.parameterTypes[i].primitiveJavaClass || types[i].isAssignableFrom(this.parameterTypes[i].primitiveJavaClass)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return method;
        }
        return clazz.getMethod(name, this.parameterClasses);
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.functionName()).append('(');
        for (int i = 0; i < children.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(children[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    protected abstract String functionName();
}

