/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.PTFUtils;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.PTFTranslator;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Explain(displayName="PTF Operator")
public class PTFDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)PTFDesc.class.getName());
    PartitionedTableFunctionDef funcDef;
    PTFTranslator.LeadLagInfo llInfo;
    boolean isMapSide = false;

    public PartitionedTableFunctionDef getFuncDef() {
        return this.funcDef;
    }

    public void setFuncDef(PartitionedTableFunctionDef funcDef) {
        this.funcDef = funcDef;
    }

    public PartitionedTableFunctionDef getStartOfChain() {
        return this.funcDef == null ? null : this.funcDef.getStartOfChain();
    }

    public PTFTranslator.LeadLagInfo getLlInfo() {
        return this.llInfo;
    }

    public void setLlInfo(PTFTranslator.LeadLagInfo llInfo) {
        this.llInfo = llInfo;
    }

    public boolean forWindowing() {
        return this.funcDef != null && this.funcDef instanceof WindowTableFunctionDef;
    }

    public boolean isMapSide() {
        return this.isMapSide;
    }

    public void setMapSide(boolean isMapSide) {
        this.isMapSide = isMapSide;
    }

    static {
        PTFUtils.makeTransient(PTFDesc.class, "llInfo");
    }

    public static class PTFExpressionDef {
        String expressionTreeString;
        ExprNodeDesc exprNode;
        transient ExprNodeEvaluator exprEvaluator;
        transient ObjectInspector OI;

        public PTFExpressionDef() {
        }

        public PTFExpressionDef(PTFExpressionDef e) {
            this.expressionTreeString = e.getExpressionTreeString();
            this.exprNode = e.getExprNode();
            this.exprEvaluator = e.getExprEvaluator();
            this.OI = e.getOI();
        }

        public String getExpressionTreeString() {
            return this.expressionTreeString;
        }

        public void setExpressionTreeString(String expressionTreeString) {
            this.expressionTreeString = expressionTreeString;
        }

        public ExprNodeDesc getExprNode() {
            return this.exprNode;
        }

        public void setExprNode(ExprNodeDesc exprNode) {
            this.exprNode = exprNode;
        }

        public ExprNodeEvaluator getExprEvaluator() {
            return this.exprEvaluator;
        }

        public void setExprEvaluator(ExprNodeEvaluator exprEvaluator) {
            this.exprEvaluator = exprEvaluator;
        }

        public ObjectInspector getOI() {
            return this.OI;
        }

        public void setOI(ObjectInspector oI) {
            this.OI = oI;
        }

        static {
            PTFUtils.makeTransient(PTFExpressionDef.class, "exprEvaluator", "OI");
        }
    }

    public static class ValueBoundaryDef
    extends BoundaryDef {
        PTFExpressionDef expressionDef;
        int amt;

        public int compareTo(BoundaryDef other) {
            int c = this.getDirection().compareTo(other.getDirection());
            if (c != 0) {
                return c;
            }
            ValueBoundaryDef vb = (ValueBoundaryDef)other;
            return this.getAmt() - vb.getAmt();
        }

        public PTFExpressionDef getExpressionDef() {
            return this.expressionDef;
        }

        public void setExpressionDef(PTFExpressionDef expressionDef) {
            this.expressionDef = expressionDef;
        }

        public ExprNodeDesc getExprNode() {
            return this.expressionDef == null ? null : this.expressionDef.getExprNode();
        }

        public ExprNodeEvaluator getExprEvaluator() {
            return this.expressionDef == null ? null : this.expressionDef.getExprEvaluator();
        }

        public ObjectInspector getOI() {
            return this.expressionDef == null ? null : this.expressionDef.getOI();
        }

        @Override
        public int getAmt() {
            return this.amt;
        }

        public void setAmt(int amt) {
            this.amt = amt;
        }
    }

    public static class CurrentRowDef
    extends BoundaryDef {
        public int compareTo(BoundaryDef other) {
            return this.getDirection().compareTo(other.getDirection());
        }

        @Override
        public WindowingSpec.Direction getDirection() {
            return WindowingSpec.Direction.CURRENT;
        }

        @Override
        public int getAmt() {
            return 0;
        }
    }

    public static class RangeBoundaryDef
    extends BoundaryDef {
        int amt;

        public int compareTo(BoundaryDef other) {
            int c = this.getDirection().compareTo(other.getDirection());
            if (c != 0) {
                return c;
            }
            RangeBoundaryDef rb = (RangeBoundaryDef)other;
            return this.getAmt() - rb.getAmt();
        }

        @Override
        public int getAmt() {
            return this.amt;
        }

        public void setAmt(int amt) {
            this.amt = amt;
        }
    }

    public static abstract class BoundaryDef {
        WindowingSpec.Direction direction;

        public WindowingSpec.Direction getDirection() {
            return this.direction;
        }

        public void setDirection(WindowingSpec.Direction direction) {
            this.direction = direction;
        }

        public abstract int getAmt();
    }

    public static class WindowFrameDef {
        BoundaryDef start;
        BoundaryDef end;

        public BoundaryDef getStart() {
            return this.start;
        }

        public void setStart(BoundaryDef start) {
            this.start = start;
        }

        public BoundaryDef getEnd() {
            return this.end;
        }

        public void setEnd(BoundaryDef end) {
            this.end = end;
        }
    }

    public static class WindowFunctionDef
    extends WindowExpressionDef {
        String name;
        boolean isStar;
        boolean isDistinct;
        ArrayList<PTFExpressionDef> args;
        WindowFrameDef windowFrame;
        GenericUDAFEvaluator wFnEval;
        boolean pivotResult;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isStar() {
            return this.isStar;
        }

        public void setStar(boolean isStar) {
            this.isStar = isStar;
        }

        public boolean isDistinct() {
            return this.isDistinct;
        }

        public void setDistinct(boolean isDistinct) {
            this.isDistinct = isDistinct;
        }

        public ArrayList<PTFExpressionDef> getArgs() {
            return this.args;
        }

        public void setArgs(ArrayList<PTFExpressionDef> args) {
            this.args = args;
        }

        public void addArg(PTFExpressionDef arg) {
            this.args = this.args == null ? new ArrayList<PTFExpressionDef>() : this.args;
            this.args.add(arg);
        }

        public WindowFrameDef getWindowFrame() {
            return this.windowFrame;
        }

        public void setWindowFrame(WindowFrameDef windowFrame) {
            this.windowFrame = windowFrame;
        }

        public GenericUDAFEvaluator getWFnEval() {
            return this.wFnEval;
        }

        public void setWFnEval(GenericUDAFEvaluator wFnEval) {
            this.wFnEval = wFnEval;
        }

        public boolean isPivotResult() {
            return this.pivotResult;
        }

        public void setPivotResult(boolean pivotResult) {
            this.pivotResult = pivotResult;
        }
    }

    public static class WindowExpressionDef
    extends PTFExpressionDef {
        String alias;

        public WindowExpressionDef() {
        }

        public WindowExpressionDef(PTFExpressionDef eDef) {
            super(eDef);
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }
    }

    public static class OrderExpressionDef
    extends PTFExpressionDef {
        PTFInvocationSpec.Order order;

        public OrderExpressionDef() {
        }

        public OrderExpressionDef(PTFExpressionDef e) {
            super(e);
            this.order = PTFInvocationSpec.Order.ASC;
        }

        public PTFInvocationSpec.Order getOrder() {
            return this.order;
        }

        public void setOrder(PTFInvocationSpec.Order order) {
            this.order = order;
        }
    }

    public static class OrderDef {
        ArrayList<OrderExpressionDef> expressions;

        public OrderDef() {
        }

        public OrderDef(PartitionDef pDef) {
            for (PTFExpressionDef eDef : pDef.getExpressions()) {
                this.addExpression(new OrderExpressionDef(eDef));
            }
        }

        public ArrayList<OrderExpressionDef> getExpressions() {
            return this.expressions;
        }

        public void setExpressions(ArrayList<OrderExpressionDef> expressions) {
            this.expressions = expressions;
        }

        public void addExpression(OrderExpressionDef e) {
            this.expressions = this.expressions == null ? new ArrayList<OrderExpressionDef>() : this.expressions;
            this.expressions.add(e);
        }
    }

    public static class PartitionDef {
        ArrayList<PTFExpressionDef> expressions;

        public ArrayList<PTFExpressionDef> getExpressions() {
            return this.expressions;
        }

        public void setExpressions(ArrayList<PTFExpressionDef> expressions) {
            this.expressions = expressions;
        }

        public void addExpression(PTFExpressionDef e) {
            this.expressions = this.expressions == null ? new ArrayList<PTFExpressionDef>() : this.expressions;
            this.expressions.add(e);
        }
    }

    public static class ShapeDetails {
        String serdeClassName;
        Map<String, String> serdeProps;
        ArrayList<String> columnNames;
        transient StructObjectInspector OI;
        transient SerDe serde;
        transient RowResolver rr;
        transient TypeCheckCtx typeCheckCtx;

        public String getSerdeClassName() {
            return this.serdeClassName;
        }

        public void setSerdeClassName(String serdeClassName) {
            this.serdeClassName = serdeClassName;
        }

        public Map<String, String> getSerdeProps() {
            return this.serdeProps;
        }

        public void setSerdeProps(Map<String, String> serdeProps) {
            this.serdeProps = serdeProps;
        }

        public ArrayList<String> getColumnNames() {
            return this.columnNames;
        }

        public void setColumnNames(ArrayList<String> columnNames) {
            this.columnNames = columnNames;
        }

        public StructObjectInspector getOI() {
            return this.OI;
        }

        public void setOI(StructObjectInspector oI) {
            this.OI = oI;
        }

        public SerDe getSerde() {
            return this.serde;
        }

        public void setSerde(SerDe serde) {
            this.serde = serde;
        }

        public RowResolver getRr() {
            return this.rr;
        }

        public void setRr(RowResolver rr) {
            this.rr = rr;
        }

        public TypeCheckCtx getTypeCheckCtx() {
            return this.typeCheckCtx;
        }

        public void setTypeCheckCtx(TypeCheckCtx typeCheckCtx) {
            this.typeCheckCtx = typeCheckCtx;
        }

        static {
            PTFUtils.makeTransient(ShapeDetails.class, "OI", "serde", "rr", "typeCheckCtx");
        }
    }

    public static class WindowTableFunctionDef
    extends PartitionedTableFunctionDef {
        ArrayList<WindowExpressionDef> windowExpressions;
        ArrayList<WindowFunctionDef> windowFunctions;
        ShapeDetails outputFromWdwFnProcessing;

        public ArrayList<WindowExpressionDef> getWindowExpressions() {
            return this.windowExpressions;
        }

        public void setWindowExpressions(ArrayList<WindowExpressionDef> windowExpressions) {
            this.windowExpressions = windowExpressions;
        }

        public ShapeDetails getOutputFromWdwFnProcessing() {
            return this.outputFromWdwFnProcessing;
        }

        public void setOutputFromWdwFnProcessing(ShapeDetails outputFromWdwFnProcessing) {
            this.outputFromWdwFnProcessing = outputFromWdwFnProcessing;
        }

        public ArrayList<WindowFunctionDef> getWindowFunctions() {
            return this.windowFunctions;
        }

        public void setWindowFunctions(ArrayList<WindowFunctionDef> windowFunctions) {
            this.windowFunctions = windowFunctions;
        }
    }

    public static class PartitionedTableFunctionDef
    extends PTFInputDef {
        String name;
        String resolverClassName;
        ShapeDetails rawInputShape;
        boolean carryForwardNames;
        PTFInputDef input;
        ArrayList<PTFExpressionDef> args;
        PartitionDef partition;
        OrderDef order;
        TableFunctionEvaluator tFunction;
        boolean transformsRawInput;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ShapeDetails getRawInputShape() {
            return this.rawInputShape;
        }

        public void setRawInputShape(ShapeDetails rawInputShape) {
            this.rawInputShape = rawInputShape;
        }

        public boolean isCarryForwardNames() {
            return this.carryForwardNames;
        }

        public void setCarryForwardNames(boolean carryForwardNames) {
            this.carryForwardNames = carryForwardNames;
        }

        @Override
        public PTFInputDef getInput() {
            return this.input;
        }

        public void setInput(PTFInputDef input) {
            this.input = input;
        }

        public PartitionDef getPartition() {
            return this.partition;
        }

        public void setPartition(PartitionDef partition) {
            this.partition = partition;
        }

        public OrderDef getOrder() {
            return this.order;
        }

        public void setOrder(OrderDef order) {
            this.order = order;
        }

        public TableFunctionEvaluator getTFunction() {
            return this.tFunction;
        }

        public void setTFunction(TableFunctionEvaluator tFunction) {
            this.tFunction = tFunction;
        }

        public ArrayList<PTFExpressionDef> getArgs() {
            return this.args;
        }

        public void setArgs(ArrayList<PTFExpressionDef> args) {
            this.args = args;
        }

        public void addArg(PTFExpressionDef arg) {
            this.args = this.args == null ? new ArrayList<PTFExpressionDef>() : this.args;
            this.args.add(arg);
        }

        public PartitionedTableFunctionDef getStartOfChain() {
            if (this.input instanceof PartitionedTableFunctionDef) {
                return ((PartitionedTableFunctionDef)this.input).getStartOfChain();
            }
            return this;
        }

        public boolean isTransformsRawInput() {
            return this.transformsRawInput;
        }

        public void setTransformsRawInput(boolean transformsRawInput) {
            this.transformsRawInput = transformsRawInput;
        }

        public String getResolverClassName() {
            return this.resolverClassName;
        }

        public void setResolverClassName(String resolverClassName) {
            this.resolverClassName = resolverClassName;
        }
    }

    public static class PTFQueryInputDef
    extends PTFInputDef {
        String destination;
        PTFInvocationSpec.PTFQueryInputType type;

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public PTFInvocationSpec.PTFQueryInputType getType() {
            return this.type;
        }

        public void setType(PTFInvocationSpec.PTFQueryInputType type) {
            this.type = type;
        }

        @Override
        public PTFInputDef getInput() {
            return null;
        }
    }

    public static abstract class PTFInputDef {
        String expressionTreeString;
        ShapeDetails outputShape;
        String alias;

        public String getExpressionTreeString() {
            return this.expressionTreeString;
        }

        public void setExpressionTreeString(String expressionTreeString) {
            this.expressionTreeString = expressionTreeString;
        }

        public ShapeDetails getOutputShape() {
            return this.outputShape;
        }

        public void setOutputShape(ShapeDetails outputShape) {
            this.outputShape = outputShape;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public abstract PTFInputDef getInput();
    }
}

