/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.hbase;

import java.io.IOException;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.VertexWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class HBaseVertexOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexOutputFormat<I, V, E> {
    protected static final TableOutputFormat<ImmutableBytesWritable> BASE_FORMAT = new TableOutputFormat();

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        BASE_FORMAT.checkOutputSpecs(context);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        BASE_FORMAT.setConf((Configuration)this.getConf());
        return BASE_FORMAT.getOutputCommitter(context);
    }

    public static abstract class HBaseVertexWriter<I extends WritableComparable, V extends Writable, E extends Writable>
    extends VertexWriter<I, V, E> {
        private TaskAttemptContext context;
        private RecordWriter<ImmutableBytesWritable, Writable> recordWriter;

        public HBaseVertexWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            BASE_FORMAT.setConf(context.getConfiguration());
            this.recordWriter = BASE_FORMAT.getRecordWriter(context);
        }

        public void initialize(TaskAttemptContext context) throws IOException {
            this.context = context;
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.recordWriter.close(context);
        }

        public RecordWriter<ImmutableBytesWritable, Writable> getRecordWriter() {
            return this.recordWriter;
        }

        public TaskAttemptContext getContext() {
            return this.context;
        }
    }
}

