/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.shims;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.util.Progressable;
import org.apache.hcatalog.shims.HCatHadoopShims;

public class HCatHadoopShims20S
implements HCatHadoopShims {
    @Override
    public TaskID createTaskID() {
        return new TaskID();
    }

    @Override
    public TaskAttemptID createTaskAttemptID() {
        return new TaskAttemptID();
    }

    @Override
    public TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taskId) {
        return new TaskAttemptContext(conf, taskId);
    }

    @Override
    public org.apache.hadoop.mapred.TaskAttemptContext createTaskAttemptContext(JobConf conf, org.apache.hadoop.mapred.TaskAttemptID taskId, Progressable progressable) {
        org.apache.hadoop.mapred.TaskAttemptContext newContext = null;
        try {
            Constructor construct = org.apache.hadoop.mapred.TaskAttemptContext.class.getDeclaredConstructor(JobConf.class, org.apache.hadoop.mapred.TaskAttemptID.class, Progressable.class);
            construct.setAccessible(true);
            newContext = (org.apache.hadoop.mapred.TaskAttemptContext)construct.newInstance(conf, taskId, progressable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newContext;
    }

    @Override
    public JobContext createJobContext(Configuration conf, JobID jobId) {
        return new JobContext(conf, jobId);
    }

    @Override
    public org.apache.hadoop.mapred.JobContext createJobContext(JobConf conf, JobID jobId, Progressable progressable) {
        org.apache.hadoop.mapred.JobContext newContext = null;
        try {
            Constructor construct = org.apache.hadoop.mapred.JobContext.class.getDeclaredConstructor(JobConf.class, JobID.class, Progressable.class);
            construct.setAccessible(true);
            newContext = (org.apache.hadoop.mapred.JobContext)construct.newInstance(conf, jobId, progressable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newContext;
    }

    @Override
    public void commitJob(OutputFormat outputFormat, Job job) throws IOException {
        if (job.getConfiguration().get("mapred.job.tracker", "").equalsIgnoreCase("local")) {
            try {
                outputFormat.getOutputCommitter(HCatHadoopShims.Instance.get().createTaskAttemptContext(job.getConfiguration(), HCatHadoopShims.Instance.get().createTaskAttemptID())).commitJob((JobContext)job);
            }
            catch (IOException e) {
                throw new IOException("Failed to cleanup job", e);
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to cleanup job", e);
            }
        }
    }

    @Override
    public void abortJob(OutputFormat outputFormat, Job job) throws IOException {
        if (job.getConfiguration().get("mapred.job.tracker", "").equalsIgnoreCase("local")) {
            try {
                outputFormat.getOutputCommitter(HCatHadoopShims.Instance.get().createTaskAttemptContext(job.getConfiguration(), new TaskAttemptID())).abortJob((JobContext)job, JobStatus.State.FAILED);
            }
            catch (IOException e) {
                throw new IOException("Failed to abort job", e);
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to abort job", e);
            }
        }
    }

    @Override
    public InetSocketAddress getResourceManagerAddress(Configuration conf) {
        return JobTracker.getAddress((Configuration)conf);
    }

    @Override
    public String getPropertyName(HCatHadoopShims.PropertyName name) {
        switch (name) {
            case CACHE_ARCHIVES: {
                return "mapred.cache.archives";
            }
            case CACHE_FILES: {
                return "mapred.cache.files";
            }
            case CACHE_SYMLINK: {
                return "mapred.create.symlink";
            }
        }
        return "";
    }

    @Override
    public boolean isFileInHDFS(FileSystem fs, Path path) throws IOException {
        return "hdfs".equals(fs.getUri().getScheme());
    }
}

