/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.shims;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.util.Progressable;

public interface HCatHadoopShims {
    public TaskID createTaskID();

    public TaskAttemptID createTaskAttemptID();

    public TaskAttemptContext createTaskAttemptContext(Configuration var1, TaskAttemptID var2);

    public org.apache.hadoop.mapred.TaskAttemptContext createTaskAttemptContext(JobConf var1, org.apache.hadoop.mapred.TaskAttemptID var2, Progressable var3);

    public JobContext createJobContext(Configuration var1, JobID var2);

    public org.apache.hadoop.mapred.JobContext createJobContext(JobConf var1, JobID var2, Progressable var3);

    public void commitJob(OutputFormat var1, Job var2) throws IOException;

    public void abortJob(OutputFormat var1, Job var2) throws IOException;

    public InetSocketAddress getResourceManagerAddress(Configuration var1);

    public String getPropertyName(PropertyName var1);

    public boolean isFileInHDFS(FileSystem var1, Path var2) throws IOException;

    public static abstract class Instance {
        static HCatHadoopShims instance = Instance.selectShim();

        public static HCatHadoopShims get() {
            return instance;
        }

        private static HCatHadoopShims selectShim() {
            String major = ShimLoader.getMajorVersion();
            String shimFQN = "org.apache.hcatalog.shims.HCatHadoopShims20S";
            if (major.startsWith("0.23")) {
                shimFQN = "org.apache.hcatalog.shims.HCatHadoopShims23";
            }
            try {
                Class<HCatHadoopShims> clasz = Class.forName(shimFQN).asSubclass(HCatHadoopShims.class);
                return clasz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate: " + shimFQN, e);
            }
        }
    }

    public static enum PropertyName {
        CACHE_ARCHIVES,
        CACHE_FILES,
        CACHE_SYMLINK;

    }
}

