/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.security;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProviderBase;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;

public class HdfsAuthorizationProvider
extends HiveAuthorizationProviderBase {
    protected Warehouse wh;
    private static final String PROXY_USER_NAME = "proxy.user.name";
    private static final String DATABASE_WAREHOUSE_SUFFIX = ".db";

    public HdfsAuthorizationProvider() {
    }

    public HdfsAuthorizationProvider(Configuration conf) {
        this.setConf(conf);
    }

    public void init(Configuration conf) throws HiveException {
        this.hive_db = new HiveAuthorizationProviderBase.HiveProxy((HiveAuthorizationProviderBase)this, Hive.get((HiveConf)new HiveConf(conf, HiveAuthorizationProvider.class)));
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        try {
            this.wh = new Warehouse(conf);
        }
        catch (MetaException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected FsAction getFsAction(Privilege priv, Path path) {
        switch (priv.getPriv()) {
            case ALL: {
                throw new AuthorizationException("no matching Action for Privilege.All");
            }
            case ALTER_DATA: {
                return FsAction.WRITE;
            }
            case ALTER_METADATA: {
                return FsAction.WRITE;
            }
            case CREATE: {
                return FsAction.WRITE;
            }
            case DROP: {
                return FsAction.WRITE;
            }
            case INDEX: {
                return FsAction.WRITE;
            }
            case LOCK: {
                return FsAction.WRITE;
            }
            case SELECT: {
                return FsAction.READ;
            }
            case SHOW_DATABASE: {
                return FsAction.READ;
            }
        }
        throw new AuthorizationException("Unknown privilege");
    }

    protected EnumSet<FsAction> getFsActions(Privilege[] privs, Path path) {
        EnumSet<FsAction> actions = EnumSet.noneOf(FsAction.class);
        if (privs == null) {
            return actions;
        }
        for (Privilege priv : privs) {
            actions.add(this.getFsAction(priv, path));
        }
        return actions;
    }

    private Path getDefaultDatabasePath(String dbName) throws MetaException {
        if (dbName.equalsIgnoreCase("default")) {
            return this.wh.getWhRoot();
        }
        return new Path(this.wh.getWhRoot(), dbName.toLowerCase() + DATABASE_WAREHOUSE_SUFFIX);
    }

    protected Path getDbLocation(Database db) throws HiveException {
        try {
            String location = db.getLocationUri();
            if (location == null) {
                return this.getDefaultDatabasePath(db.getName());
            }
            return this.wh.getDnsPath(this.wh.getDatabasePath(db));
        }
        catch (MetaException ex) {
            throw new HiveException(ex.getMessage());
        }
    }

    public void authorize(Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        try {
            Path root = this.wh.getWhRoot();
            this.authorize(root, readRequiredPriv, writeRequiredPriv);
        }
        catch (MetaException ex) {
            throw new HiveException((Throwable)ex);
        }
    }

    public void authorize(Database db, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        if (db == null) {
            return;
        }
        Path path = this.getDbLocation(db);
        this.authorize(path, readRequiredPriv, writeRequiredPriv);
    }

    public void authorize(Table table, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        if (table == null) {
            return;
        }
        Path path = null;
        try {
            path = table.getTTable().getSd().getLocation() == null || table.getTTable().getSd().getLocation().isEmpty() ? this.wh.getTablePath(this.hive_db.getDatabase(table.getDbName()), table.getTableName()) : table.getPath();
        }
        catch (MetaException ex) {
            throw new HiveException((Throwable)ex);
        }
        this.authorize(path, readRequiredPriv, writeRequiredPriv);
    }

    public void authorize(Table table, Partition part, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        if (part == null || part.getLocation() == null) {
            this.authorize(table, readRequiredPriv, writeRequiredPriv);
        } else {
            this.authorize(part.getPartitionPath(), readRequiredPriv, writeRequiredPriv);
        }
    }

    public void authorize(Partition part, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        if (part == null) {
            return;
        }
        this.authorize(part.getTable(), part, readRequiredPriv, writeRequiredPriv);
    }

    public void authorize(Table table, Partition part, List<String> columns, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        this.authorize(table, part, readRequiredPriv, writeRequiredPriv);
    }

    public void authorize(Path path, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        try {
            EnumSet<FsAction> actions = this.getFsActions(readRequiredPriv, path);
            actions.addAll(this.getFsActions(writeRequiredPriv, path));
            if (actions.isEmpty()) {
                return;
            }
            HdfsAuthorizationProvider.checkPermissions(this.getConf(), path, actions);
        }
        catch (AccessControlException ex) {
            throw new AuthorizationException((Throwable)ex);
        }
        catch (LoginException ex) {
            throw new AuthorizationException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new HiveException((Throwable)ex);
        }
    }

    protected static void checkPermissions(Configuration conf, Path path, EnumSet<FsAction> actions) throws IOException, LoginException {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        HadoopShims shims = ShimLoader.getHadoopShims();
        UserGroupInformation ugi = conf.get(PROXY_USER_NAME) != null ? UserGroupInformation.createRemoteUser((String)conf.get(PROXY_USER_NAME)) : shims.getUGIForConf(conf);
        String user = shims.getShortUserName(ugi);
        FileSystem fs = path.getFileSystem(conf);
        if (fs.exists(path)) {
            HdfsAuthorizationProvider.checkPermissions(fs, path, actions, user, ugi.getGroupNames());
        } else if (path.getParent() != null) {
            Path par;
            for (par = path.getParent(); par != null && !fs.exists(par); par = par.getParent()) {
            }
            HdfsAuthorizationProvider.checkPermissions(fs, par, actions, user, ugi.getGroupNames());
        }
    }

    protected static void checkPermissions(FileSystem fs, Path path, EnumSet<FsAction> actions, String user, String[] groups) throws IOException, AccessControlException {
        FileStatus stat;
        try {
            stat = fs.getFileStatus(path);
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        catch (org.apache.hadoop.fs.permission.AccessControlException ace) {
            throw new AccessControlException(ace.getMessage());
        }
        FsPermission dirPerms = stat.getPermission();
        String grp = stat.getGroup();
        for (FsAction action : actions) {
            if (user.equals(stat.getOwner()) && dirPerms.getUserAction().implies(action) || ArrayUtils.contains((Object[])groups, (Object)grp) && dirPerms.getGroupAction().implies(action) || dirPerms.getOtherAction().implies(action)) continue;
            throw new AccessControlException("action " + action + " not permitted on path " + path + " for user " + user);
        }
    }
}

