/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.mapreduce.FileOutputFormatContainer;
import org.apache.hcatalog.mapreduce.HCatStorageHandler;
import org.apache.hcatalog.mapreduce.OutputFormatContainer;
import org.apache.hcatalog.mapreduce.OutputJobInfo;

public class FosterStorageHandler
extends HCatStorageHandler {
    public Configuration conf;
    protected static final String DYNTEMP_DIR_NAME = "_DYN";
    protected static final String TEMP_DIR_NAME = "_TEMP";
    private Class<? extends InputFormat> ifClass;
    private Class<? extends OutputFormat> ofClass;
    private Class<? extends SerDe> serDeClass;

    public FosterStorageHandler(String ifName, String ofName, String serdeName) throws ClassNotFoundException {
        this(Class.forName(ifName), Class.forName(ofName), Class.forName(serdeName));
    }

    public FosterStorageHandler(Class<? extends InputFormat> ifClass, Class<? extends OutputFormat> ofClass, Class<? extends SerDe> serDeClass) {
        this.ifClass = ifClass;
        this.ofClass = ofClass;
        this.serDeClass = serDeClass;
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return this.ifClass;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return this.ofClass;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return this.serDeClass;
    }

    public HiveMetaHook getMetaHook() {
        return null;
    }

    @Override
    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
    }

    @Override
    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        try {
            String outputLocation;
            OutputJobInfo jobInfo = (OutputJobInfo)HCatUtil.deserialize((String)tableDesc.getJobProperties().get("mapreduce.lib.hcatoutput.info"));
            String parentPath = jobInfo.getTableInfo().getTableLocation();
            String dynHash = (String)tableDesc.getJobProperties().get("mapreduce.lib.hcatoutputdynamic.jobid");
            if (dynHash != null) {
                parentPath = new Path(parentPath, DYNTEMP_DIR_NAME + dynHash).toString();
            }
            if (Boolean.valueOf((String)tableDesc.getProperties().get("EXTERNAL")).booleanValue() && jobInfo.getLocation() != null && jobInfo.getLocation().length() > 0) {
                outputLocation = jobInfo.getLocation();
            } else if (dynHash == null && jobInfo.getPartitionValues().size() == 0) {
                outputLocation = TEMP_DIR_NAME;
            } else {
                ArrayList<String> cols = new ArrayList<String>();
                ArrayList<String> values = new ArrayList<String>();
                for (String name : jobInfo.getTableInfo().getPartitionColumns().getFieldNames()) {
                    String value = jobInfo.getPartitionValues().get(name);
                    cols.add(name);
                    values.add(value);
                }
                outputLocation = FileUtils.makePartName(cols, values);
            }
            jobInfo.setLocation(new Path(parentPath, outputLocation).toString());
            if (jobInfo.getPartitionValues().size() == jobInfo.getTableInfo().getPartitionColumns().size()) {
                jobProperties.put("mapred.output.dir", jobInfo.getLocation());
            }
            jobProperties.put("hive.io.rcfile.column.number.conf", Integer.toOctalString(jobInfo.getOutputSchema().getFields().size()));
            jobProperties.put("mapreduce.lib.hcatoutput.info", HCatUtil.serialize(jobInfo));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to set output path", e);
        }
    }

    @Override
    OutputFormatContainer getOutputFormatContainer(OutputFormat outputFormat) {
        return new FileOutputFormatContainer(outputFormat);
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return new DefaultHiveAuthorizationProvider();
    }
}

