/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.data.transfer.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hcatalog.common.ErrorType;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.hcatalog.data.transfer.HCatWriter;
import org.apache.hcatalog.data.transfer.WriteEntity;
import org.apache.hcatalog.data.transfer.WriterContext;
import org.apache.hcatalog.data.transfer.state.StateProvider;
import org.apache.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hcatalog.shims.HCatHadoopShims;

public class HCatOutputFormatWriter
extends HCatWriter {
    public HCatOutputFormatWriter(WriteEntity we, Map<String, String> config) {
        super(we, config);
    }

    public HCatOutputFormatWriter(Configuration config, StateProvider sp) {
        super(config, sp);
    }

    @Override
    public WriterContext prepareWrite() throws HCatException {
        Job job;
        OutputJobInfo jobInfo = OutputJobInfo.create(this.we.getDbName(), this.we.getTableName(), this.we.getPartitionKVs());
        try {
            job = new Job(this.conf);
            HCatOutputFormat.setOutput(job, jobInfo);
            HCatOutputFormat.setSchema(job, HCatOutputFormat.getTableSchema((JobContext)job));
            HCatOutputFormat outFormat = new HCatOutputFormat();
            outFormat.checkOutputSpecs((JobContext)job);
            outFormat.getOutputCommitter(HCatHadoopShims.Instance.get().createTaskAttemptContext(job.getConfiguration(), HCatHadoopShims.Instance.get().createTaskAttemptID())).setupJob((JobContext)job);
        }
        catch (IOException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
        WriterContext cntxt = new WriterContext();
        cntxt.setConf(job.getConfiguration());
        return cntxt;
    }

    @Override
    public void write(Iterator<HCatRecord> recordItr) throws HCatException {
        int id = this.sp.getId();
        this.setVarsInConf(id);
        HCatOutputFormat outFormat = new HCatOutputFormat();
        TaskAttemptContext cntxt = HCatHadoopShims.Instance.get().createTaskAttemptContext(this.conf, new TaskAttemptID(HCatHadoopShims.Instance.get().createTaskID(), id));
        OutputCommitter committer = null;
        try {
            committer = outFormat.getOutputCommitter(cntxt);
            committer.setupTask(cntxt);
            RecordWriter<WritableComparable<?>, HCatRecord> writer = outFormat.getRecordWriter(cntxt);
            while (recordItr.hasNext()) {
                HCatRecord rec = recordItr.next();
                writer.write(null, (Object)rec);
            }
            writer.close(cntxt);
            if (committer.needsTaskCommit(cntxt)) {
                committer.commitTask(cntxt);
            }
        }
        catch (IOException e) {
            if (null != committer) {
                try {
                    committer.abortTask(cntxt);
                }
                catch (IOException e1) {
                    throw new HCatException(ErrorType.ERROR_INTERNAL_EXCEPTION, (Throwable)e1);
                }
            }
            throw new HCatException("Failed while writing", (Throwable)e);
        }
        catch (InterruptedException e) {
            if (null != committer) {
                try {
                    committer.abortTask(cntxt);
                }
                catch (IOException e1) {
                    throw new HCatException(ErrorType.ERROR_INTERNAL_EXCEPTION, (Throwable)e1);
                }
            }
            throw new HCatException("Failed while writing", (Throwable)e);
        }
    }

    @Override
    public void commit(WriterContext context) throws HCatException {
        try {
            new HCatOutputFormat().getOutputCommitter(HCatHadoopShims.Instance.get().createTaskAttemptContext(context.getConf(), HCatHadoopShims.Instance.get().createTaskAttemptID())).commitJob(HCatHadoopShims.Instance.get().createJobContext(context.getConf(), null));
        }
        catch (IOException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
    }

    @Override
    public void abort(WriterContext context) throws HCatException {
        try {
            new HCatOutputFormat().getOutputCommitter(HCatHadoopShims.Instance.get().createTaskAttemptContext(context.getConf(), HCatHadoopShims.Instance.get().createTaskAttemptID())).abortJob(HCatHadoopShims.Instance.get().createJobContext(context.getConf(), null), JobStatus.State.FAILED);
        }
        catch (IOException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
    }

    private void setVarsInConf(int id) {
        this.conf.setInt("mapred.task.partition", id);
        this.conf.set("mapred.task.id", "attempt__0000_r_000000_" + id);
    }
}

