/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.data.transfer;

import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.hcatalog.data.transfer.ReadEntity;
import org.apache.hcatalog.data.transfer.ReaderContext;
import org.apache.hcatalog.data.transfer.state.StateProvider;

public abstract class HCatReader {
    protected ReadEntity re;
    protected Configuration conf;
    protected ReaderContext info;
    protected StateProvider sp;

    public abstract ReaderContext prepareRead() throws HCatException;

    public abstract Iterator<HCatRecord> read() throws HCatException;

    protected HCatReader(ReadEntity re, Map<String, String> config) {
        this(config);
        this.re = re;
    }

    protected HCatReader(Configuration config, StateProvider sp) {
        this.conf = config;
        this.sp = sp;
    }

    private HCatReader(Map<String, String> config) {
        Configuration conf = new Configuration();
        if (null != config) {
            for (Map.Entry<String, String> kv : config.entrySet()) {
                conf.set(kv.getKey(), kv.getValue());
            }
        }
        this.conf = conf;
    }

    public Configuration getConf() {
        if (null == this.conf) {
            throw new IllegalStateException("HCatReader is not constructed correctly.");
        }
        return this.conf;
    }
}

