/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.common;

import java.io.IOException;
import org.apache.hcatalog.common.ErrorType;

public class HCatException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final ErrorType errorType;

    public HCatException(ErrorType errorType) {
        this(errorType, null, null);
    }

    public HCatException(ErrorType errorType, Throwable cause) {
        this(errorType, null, cause);
    }

    public HCatException(ErrorType errorType, String extraMessage) {
        this(errorType, extraMessage, null);
    }

    public HCatException(ErrorType errorType, String extraMessage, Throwable cause) {
        super(HCatException.buildErrorMessage(errorType, extraMessage, cause), cause);
        this.errorType = errorType;
    }

    public HCatException(String message) {
        this(ErrorType.ERROR_INTERNAL_EXCEPTION, message, null);
    }

    public HCatException(String message, Throwable cause) {
        this(ErrorType.ERROR_INTERNAL_EXCEPTION, message, cause);
    }

    public static String buildErrorMessage(ErrorType type, String extraMessage, Throwable cause) {
        StringBuffer message = new StringBuffer(HCatException.class.getName());
        message.append(" : " + type.getErrorCode());
        message.append(" : " + type.getErrorMessage());
        if (extraMessage != null) {
            message.append(" : " + extraMessage);
        }
        if (type.appendCauseMessage() && cause != null) {
            message.append(". Cause : " + cause.toString());
        }
        return message.toString();
    }

    public boolean isRetriable() {
        return this.errorType.isRetriable();
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public int getErrorCode() {
        return this.errorType.getErrorCode();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

