/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.cli.SemanticAnalysis;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.PartitionSpec;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hcatalog.cli.SemanticAnalysis.CreateDatabaseHook;
import org.apache.hcatalog.cli.SemanticAnalysis.CreateTableHook;
import org.apache.hcatalog.cli.SemanticAnalysis.HCatSemanticAnalyzerBase;
import org.apache.hcatalog.common.ErrorType;
import org.apache.hcatalog.common.HCatException;

public class HCatSemanticAnalyzer
extends HCatSemanticAnalyzerBase {
    private AbstractSemanticAnalyzerHook hook;
    private ASTNode ast;

    public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
        this.ast = ast;
        switch (ast.getToken().getType()) {
            case 93: {
                this.hook = new CreateTableHook();
                return this.hook.preAnalyze(context, ast);
            }
            case 92: {
                this.hook = new CreateDatabaseHook();
                return this.hook.preAnalyze(context, ast);
            }
            case 101: {
                if (((ASTNode)ast.getChild(1)).getToken().getType() == 116) {
                    return ast;
                }
                if (((ASTNode)ast.getChild(1)).getToken().getType() == 238) {
                    throw new SemanticException("Operation not supported.");
                }
                return ast;
            }
            case 94: 
            case 97: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 113: 
            case 114: 
            case 118: 
            case 119: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 159: 
            case 172: 
            case 173: 
            case 174: 
            case 176: 
            case 177: 
            case 179: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 216: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 233: 
            case 237: {
                return ast;
            }
        }
        throw new SemanticException("Operation not supported.");
    }

    @Override
    public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
        try {
            switch (this.ast.getToken().getType()) {
                case 92: 
                case 93: 
                case 94: 
                case 97: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 106: 
                case 107: 
                case 108: 
                case 110: 
                case 113: 
                case 114: 
                case 118: 
                case 119: 
                case 121: 
                case 123: 
                case 124: 
                case 126: 
                case 127: 
                case 129: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 159: 
                case 172: 
                case 173: 
                case 174: 
                case 176: 
                case 177: 
                case 179: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 216: 
                case 228: 
                case 229: 
                case 230: 
                case 231: 
                case 233: 
                case 237: {
                    break;
                }
                default: {
                    throw new HCatException(ErrorType.ERROR_INTERNAL_EXCEPTION, "Unexpected token: " + this.ast.getToken());
                }
            }
            this.authorizeDDL(context, rootTasks);
        }
        catch (HCatException e) {
            throw new SemanticException((Throwable)e);
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        if (this.hook != null) {
            this.hook.postAnalyze(context, rootTasks);
        }
    }

    private String extractTableName(String compoundName) {
        String[] words = compoundName.split("\\.");
        return words[0];
    }

    @Override
    protected void authorizeDDLWork(HiveSemanticAnalyzerHookContext cntxt, Hive hive, DDLWork work) throws HiveException {
        ShowPartitionsDesc showParts;
        DescTableDesc descTable;
        AlterTableDesc alterTable;
        DropTableDesc dropTable;
        ShowTableStatusDesc showTableStatus;
        ShowTablesDesc showTables;
        SwitchDatabaseDesc switchDb;
        DescDatabaseDesc descDb;
        DropDatabaseDesc dropDb;
        ShowDatabasesDesc showDatabases = work.getShowDatabasesDesc();
        if (showDatabases != null) {
            this.authorize(HiveOperation.SHOWDATABASES.getInputRequiredPrivileges(), HiveOperation.SHOWDATABASES.getOutputRequiredPrivileges());
        }
        if ((dropDb = work.getDropDatabaseDesc()) != null) {
            Database db = cntxt.getHive().getDatabase(dropDb.getDatabaseName());
            this.authorize(db, Privilege.DROP);
        }
        if ((descDb = work.getDescDatabaseDesc()) != null) {
            Database db = cntxt.getHive().getDatabase(descDb.getDatabaseName());
            this.authorize(db, Privilege.SELECT);
        }
        if ((switchDb = work.getSwitchDatabaseDesc()) != null) {
            Database db = cntxt.getHive().getDatabase(switchDb.getDatabaseName());
            this.authorize(db, Privilege.SELECT);
        }
        if ((showTables = work.getShowTblsDesc()) != null) {
            String dbName = showTables.getDbName() == null ? cntxt.getHive().getCurrentDatabase() : showTables.getDbName();
            this.authorize(cntxt.getHive().getDatabase(dbName), Privilege.SELECT);
        }
        if ((showTableStatus = work.getShowTblStatusDesc()) != null) {
            String dbName = showTableStatus.getDbName() == null ? cntxt.getHive().getCurrentDatabase() : showTableStatus.getDbName();
            this.authorize(cntxt.getHive().getDatabase(dbName), Privilege.SELECT);
        }
        if ((dropTable = work.getDropTblDesc()) != null && dropTable.getPartSpecs() != null) {
            for (PartitionSpec partSpec : dropTable.getPartSpecs()) {
                Table table = hive.getTable(hive.getCurrentDatabase(), dropTable.getTableName());
                List partitions = null;
                try {
                    partitions = hive.getPartitionsByFilter(table, partSpec.toString());
                }
                catch (Exception e) {
                    throw new HiveException((Throwable)e);
                }
                for (Partition part : partitions) {
                    this.authorize(part, Privilege.DROP);
                }
            }
        }
        if ((alterTable = work.getAlterTblDesc()) != null) {
            Table table = hive.getTable(hive.getCurrentDatabase(), alterTable.getOldName(), false);
            Partition part = null;
            if (alterTable.getPartSpec() != null) {
                part = hive.getPartition(table, (Map)alterTable.getPartSpec(), false);
            }
            String newLocation = alterTable.getNewLocation();
            if (alterTable.getOp() == AlterTableDesc.AlterTableTypes.ALTERLOCATION) {
                if (part != null) {
                    this.authorize(part, Privilege.ALTER_DATA);
                    part.setLocation(newLocation);
                    this.authorize(part, Privilege.ALTER_DATA);
                } else {
                    this.authorize(table, Privilege.ALTER_DATA);
                    table.getTTable().getSd().setLocation(newLocation);
                    this.authorize(table, Privilege.ALTER_DATA);
                }
            }
        }
        if ((descTable = work.getDescTblDesc()) != null) {
            String tableName = this.extractTableName(descTable.getTableName());
            this.authorizeTable(cntxt.getHive(), tableName, Privilege.SELECT);
        }
        if ((showParts = work.getShowPartsDesc()) != null) {
            String tableName = this.extractTableName(showParts.getTabName());
            this.authorizeTable(cntxt.getHive(), tableName, Privilege.SELECT);
        }
    }
}

