/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.cli.SemanticAnalysis;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hcatalog.cli.SemanticAnalysis.HCatSemanticAnalyzerBase;
import org.apache.hcatalog.common.HCatConstants;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.mapreduce.HCatStorageHandler;

final class CreateTableHook
extends HCatSemanticAnalyzerBase {
    private String tableName;

    CreateTableHook() {
    }

    public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
        Hive db;
        try {
            db = context.getHive();
        }
        catch (HiveException e) {
            throw new SemanticException("Couldn't get Hive DB instance in semantic analysis phase.", (Throwable)e);
        }
        int numCh = ast.getChildCount();
        String inputFormat = null;
        String outputFormat = null;
        this.tableName = BaseSemanticAnalyzer.getUnescapedName((ASTNode)((ASTNode)ast.getChild(0)));
        boolean likeTable = false;
        block16: for (int num = 1; num < numCh; ++num) {
            ASTNode child = (ASTNode)ast.getChild(num);
            switch (child.getToken().getType()) {
                case 5: {
                    throw new SemanticException("Operation not supported. Create table as Select is not a valid operation.");
                }
                case 142: {
                    continue block16;
                }
                case 148: {
                    inputFormat = HCatConstants.SEQUENCEFILE_INPUT;
                    outputFormat = HCatConstants.SEQUENCEFILE_OUTPUT;
                    continue block16;
                }
                case 149: {
                    inputFormat = TextInputFormat.class.getName();
                    outputFormat = IgnoreKeyTextOutputFormat.class.getName();
                    continue block16;
                }
                case 98: {
                    likeTable = true;
                    continue block16;
                }
                case 189: {
                    try {
                        List tables = db.getTablesByPattern(this.tableName);
                        if (tables == null || tables.size() <= 0) continue block16;
                        return ast;
                    }
                    catch (HiveException e) {
                        throw new SemanticException((Throwable)e);
                    }
                }
                case 141: {
                    List partCols = BaseSemanticAnalyzer.getColumns((ASTNode)((ASTNode)child.getChild(0)), (boolean)false);
                    for (FieldSchema fs : partCols) {
                        if (fs.getType().equalsIgnoreCase("string")) continue;
                        throw new SemanticException("Operation not supported. HCatalog only supports partition columns of type string. For column: " + fs.getName() + " Found type: " + fs.getType());
                    }
                    continue block16;
                }
                case 158: {
                    String storageHandler = BaseSemanticAnalyzer.unescapeSQLString((String)child.getChild(0).getText());
                    if (!StringUtils.isNotEmpty((String)storageHandler)) continue block16;
                    return ast;
                }
                case 151: {
                    if (child.getChildCount() < 2) {
                        throw new SemanticException("Incomplete specification of File Format. You must provide InputFormat, OutputFormat.");
                    }
                    inputFormat = BaseSemanticAnalyzer.unescapeSQLString((String)child.getChild(0).getText());
                    outputFormat = BaseSemanticAnalyzer.unescapeSQLString((String)child.getChild(1).getText());
                    continue block16;
                }
                case 150: {
                    inputFormat = RCFileInputFormat.class.getName();
                    outputFormat = RCFileOutputFormat.class.getName();
                }
            }
        }
        if (!(likeTable || inputFormat != null && outputFormat != null)) {
            throw new SemanticException("STORED AS specification is either incomplete or incorrect.");
        }
        return ast;
    }

    @Override
    public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
        String storageHandler;
        if (rootTasks.size() == 0) {
            return;
        }
        CreateTableDesc desc = ((DDLWork)((DDLTask)rootTasks.get(rootTasks.size() - 1)).getWork()).getCreateTblDesc();
        if (desc == null) {
            return;
        }
        HashMap tblProps = desc.getTblProps();
        if (tblProps == null) {
            tblProps = new HashMap();
        }
        if (!StringUtils.isEmpty((String)(storageHandler = desc.getStorageHandler()))) {
            try {
                HCatStorageHandler storageHandlerInst = HCatUtil.getStorageHandler(context.getConf(), desc.getStorageHandler(), desc.getSerName(), desc.getInputFormat(), desc.getOutputFormat());
            }
            catch (IOException e) {
                throw new SemanticException((Throwable)e);
            }
        }
        if (desc != null) {
            try {
                Table table = context.getHive().newTable(desc.getTableName());
                if (desc.getLocation() != null) {
                    table.setDataLocation(new Path(desc.getLocation()).toUri());
                }
                if (desc.getStorageHandler() != null) {
                    table.setProperty("storage_handler", desc.getStorageHandler());
                }
                for (Map.Entry prop : tblProps.entrySet()) {
                    table.setProperty((String)prop.getKey(), (String)prop.getValue());
                }
                for (Map.Entry prop : desc.getSerdeProps().entrySet()) {
                    table.setSerdeParam((String)prop.getKey(), (String)prop.getValue());
                }
                if (HiveConf.getBoolVar((Configuration)context.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
                    this.authorize(table, Privilege.CREATE);
                }
            }
            catch (HiveException ex) {
                throw new SemanticException((Throwable)ex);
            }
        }
        desc.setTblProps(tblProps);
        context.getConf().set("hcat.create.tbl.name", this.tableName);
    }
}

