/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class WritableUtils {
    private WritableUtils() {
    }

    public static final void writeProperties(DataOutput out, Properties props) throws IOException {
        MapWritable propsWritable = new MapWritable();
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            Text key = new Text(prop.getKey().toString());
            Text value = new Text(prop.getValue().toString());
            propsWritable.put((Writable)key, (Writable)value);
        }
        propsWritable.write(out);
    }

    public static final Properties readProperties(DataInput in) throws IOException {
        Properties props = new Properties();
        MapWritable propsWritable = new MapWritable();
        propsWritable.readFields(in);
        for (Map.Entry prop : propsWritable.entrySet()) {
            String key = ((Writable)prop.getKey()).toString();
            String value = ((Writable)prop.getValue()).toString();
            props.put(key, value);
        }
        return props;
    }
}

