/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class StringUtils {
    public static String[] joinStringArrays(String[] arr1, String ... arr2) {
        HashSet<String> set = new HashSet<String>();
        for (String str : arr1) {
            set.add(str);
        }
        for (String str : arr2) {
            set.add(str);
        }
        return set.toArray(new String[set.size()]);
    }

    public static String join(List<String> strs) {
        return StringUtils.join(new StringBuilder(), strs).toString();
    }

    public static String join(String[] strs) {
        return StringUtils.join(new StringBuilder(), strs).toString();
    }

    public static StringBuilder join(StringBuilder builder, Collection<String> strs) {
        int i = 0;
        for (String s : strs) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(s);
            ++i;
        }
        return builder;
    }

    public static StringBuilder join(StringBuilder builder, String[] strs) {
        for (int i = 0; i < strs.length; ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append(strs[i]);
        }
        return builder;
    }

    public static boolean is(String str) {
        return str != null && str.length() > 0;
    }

    public static LinkedHashSet<Set<String>> powerset(String[] set) {
        LinkedHashSet<Set<String>> power = new LinkedHashSet<Set<String>>();
        int elements = set.length;
        int powerElements = (int)Math.pow(2.0, elements);
        for (int i = 0; i < powerElements; ++i) {
            String binary = StringUtils.intToBinary(i, elements);
            LinkedHashSet<String> innerSet = new LinkedHashSet<String>();
            for (int j = 0; j < binary.length(); ++j) {
                if (binary.charAt(j) != '1') continue;
                innerSet.add(set[j]);
            }
            power.add(innerSet);
        }
        return power;
    }

    private static String intToBinary(int binary, int digits) {
        String temp = Integer.toBinaryString(binary);
        int foundDigits = temp.length();
        String returner = temp;
        for (int i = foundDigits; i < digits; ++i) {
            returner = "0" + returner;
        }
        return returner;
    }

    public static int parseInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        return Integer.parseInt(str);
    }

    public static String getClassname(Class<?> clazz) {
        return StringUtils.getClassname(clazz.getName());
    }

    public static String getClassname(String classname) {
        String[] parts = classname.split("\\.");
        return parts[parts.length - 1];
    }
}

