/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.util.ClassLoadingUtils;

public class ReflectionUtils {
    public static Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <T> Constructor<T> getConstructor(Class<T> clazz) throws SecurityException, NoSuchMethodException {
        if (clazz == null) {
            throw new IllegalArgumentException("class cannot be null");
        }
        Constructor<T> cons = clazz.getConstructor(EMPTY_CLASS_ARRAY);
        cons.setAccessible(true);
        return cons;
    }

    public static boolean hasConstructor(Class<?> clazz) throws SecurityException, NoSuchMethodException {
        if (clazz == null) {
            throw new IllegalArgumentException("class cannot be null");
        }
        Constructor<?>[] consts = clazz.getConstructors();
        boolean found = false;
        for (Constructor<?> cons : consts) {
            if (cons.getParameterTypes().length != 0) continue;
            found = true;
        }
        return found;
    }

    public static <T> T newInstance(Class<T> clazz) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        Constructor<T> cons = ReflectionUtils.getConstructor(clazz);
        return cons.newInstance(EMPTY_OBJECT_ARRAY);
    }

    public static Object newInstance(String classStr) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        if (classStr == null) {
            throw new IllegalArgumentException("class cannot be null");
        }
        Class<?> clazz = ClassLoadingUtils.loadClass(classStr);
        return ReflectionUtils.newInstance(clazz);
    }

    public static Object getStaticField(Class<?> clazz, String fieldName) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        return clazz.getField(fieldName).get(null);
    }

    public static <T extends Persistent> SpecificRecordBuilderBase<T> classBuilder(Class<T> clazz) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (SpecificRecordBuilderBase)clazz.getMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
    }
}

