/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.util;

public class ClassLoadingUtils {
    private ClassLoadingUtils() {
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        return ClassLoadingUtils.loadClass(ClassLoadingUtils.class, className);
    }

    public static Class<?> loadClass(Class<?> contextClass, String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (contextClass.getClassLoader() != null) {
            clazz = ClassLoadingUtils.loadClass(className, contextClass.getClassLoader());
        }
        if (clazz == null && Thread.currentThread().getContextClassLoader() != null) {
            clazz = ClassLoadingUtils.loadClass(className, Thread.currentThread().getContextClassLoader());
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Failed to load class" + className);
        }
        return clazz;
    }

    private static Class<?> loadClass(String className, ClassLoader classLoader) {
        Class<?> clazz = null;
        if (classLoader != null && className != null) {
            try {
                clazz = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }
}

