/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.util.Utf8;
import org.apache.gora.util.IOUtils;
import org.apache.hadoop.io.WritableUtils;

public class ByteUtils {
    public static final int SIZEOF_BOOLEAN = 1;
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_SHORT = 2;

    public static int putBytes(byte[] tgtBytes, int tgtOffset, byte[] srcBytes, int srcOffset, int srcLength) {
        System.arraycopy(srcBytes, srcOffset, tgtBytes, tgtOffset, srcLength);
        return tgtOffset + srcLength;
    }

    public static int putByte(byte[] bytes, int offset, byte b) {
        bytes[offset] = b;
        return offset + 1;
    }

    public static byte[] toBytes(ByteBuffer bb) {
        int length = bb.limit();
        byte[] result = new byte[length];
        System.arraycopy(bb.array(), bb.arrayOffset(), result, 0, length);
        return result;
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return null;
        }
        return ByteUtils.toString(b, 0, b.length);
    }

    public static String toString(byte[] b1, String sep, byte[] b2) {
        return ByteUtils.toString(b1, 0, b1.length) + sep + ByteUtils.toString(b2, 0, b2.length);
    }

    public static String toString(byte[] b, int off, int len) {
        if (b == null) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        String result = null;
        try {
            result = new String(b, off, len, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] toBytes(String s) {
        if (s == null) {
            throw new IllegalArgumentException("string cannot be null");
        }
        byte[] result = null;
        try {
            result = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] toBytes(boolean b) {
        byte[] bb = new byte[]{b ? (byte)-1 : 0};
        return bb;
    }

    public static boolean toBoolean(byte[] b) {
        if (b == null || b.length > 1) {
            throw new IllegalArgumentException("Array is wrong size");
        }
        return b[0] != 0;
    }

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static long toLong(byte[] bytes) {
        return ByteUtils.toLong(bytes, 0);
    }

    public static long toLong(byte[] bytes, int offset) {
        return ByteUtils.toLong(bytes, offset, 8);
    }

    public static long toLong(byte[] bytes, int offset, int length) {
        if (bytes == null || length != 8 || offset + length > bytes.length) {
            return -1L;
        }
        long l = 0L;
        for (int i = offset; i < offset + length; ++i) {
            l <<= 8;
            l ^= (long)bytes[i] & 0xFFL;
        }
        return l;
    }

    public static float toFloat(byte[] bytes) {
        return ByteUtils.toFloat(bytes, 0);
    }

    public static float toFloat(byte[] bytes, int offset) {
        int i = ByteUtils.toInt(bytes, offset);
        return Float.intBitsToFloat(i);
    }

    public static byte[] toBytes(float f) {
        int i = Float.floatToRawIntBits(f);
        return ByteUtils.toBytes(i);
    }

    public static double toDouble(byte[] bytes) {
        return ByteUtils.toDouble(bytes, 0);
    }

    public static double toDouble(byte[] bytes, int offset) {
        long l = ByteUtils.toLong(bytes, offset);
        return Double.longBitsToDouble(l);
    }

    public static byte[] toBytes(double d) {
        long l = Double.doubleToRawLongBits(d);
        return ByteUtils.toBytes(l);
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static int toInt(byte[] bytes) {
        return ByteUtils.toInt(bytes, 0);
    }

    public static int toInt(byte[] bytes, int offset) {
        return ByteUtils.toInt(bytes, offset, 4);
    }

    public static int toInt(byte[] bytes, int offset, int length) {
        if (bytes == null || length != 4 || offset + length > bytes.length) {
            return -1;
        }
        int n = 0;
        for (int i = offset; i < offset + length; ++i) {
            n <<= 8;
            n ^= bytes[i] & 0xFF;
        }
        return n;
    }

    public static byte[] toBytes(short val) {
        byte[] b = new byte[2];
        b[1] = (byte)val;
        val = (short)(val >> 8);
        b[0] = (byte)val;
        return b;
    }

    public static short toShort(byte[] bytes) {
        return ByteUtils.toShort(bytes, 0);
    }

    public static short toShort(byte[] bytes, int offset) {
        return ByteUtils.toShort(bytes, offset, 2);
    }

    public static short toShort(byte[] bytes, int offset, int length) {
        if (bytes == null || length != 2 || offset + length > bytes.length) {
            return -1;
        }
        short n = 0;
        n = (short)(n ^ bytes[offset] & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ bytes[offset + 1] & 0xFF);
        return n;
    }

    public static byte[] toBytes(char val) {
        byte[] b = new byte[2];
        b[1] = (byte)val;
        val = (char)(val >> 8);
        b[0] = (byte)val;
        return b;
    }

    public static char toChar(byte[] bytes) {
        return ByteUtils.toChar(bytes, 0);
    }

    public static char toChar(byte[] bytes, int offset) {
        return ByteUtils.toChar(bytes, offset, 2);
    }

    public static char toChar(byte[] bytes, int offset, int length) {
        if (bytes == null || length != 2 || offset + length > bytes.length) {
            return '\uffff';
        }
        char n = '\u0000';
        n = (char)(n ^ bytes[offset] & 0xFF);
        n = (char)(n << 8);
        n = (char)(n ^ bytes[offset + 1] & 0xFF);
        return n;
    }

    public static char[] toChars(byte[] bytes) {
        return ByteUtils.toChars(bytes, 0, bytes.length);
    }

    public static char[] toChars(byte[] bytes, int offset) {
        return ByteUtils.toChars(bytes, offset, bytes.length - offset);
    }

    public static char[] toChars(byte[] bytes, int offset, int length) {
        int max = offset + length;
        if (bytes == null || max > bytes.length || length % 2 == 1) {
            return null;
        }
        char[] chars = new char[length / 2];
        int i = 0;
        for (int j = offset; i < chars.length && j < max; ++i, j += 2) {
            int c = 0;
            c = (char)(c ^ bytes[j] & 0xFF);
            c = (char)(c << 8);
            chars[i] = c = (int)((char)(c ^ bytes[j + 1] & 0xFF));
        }
        return chars;
    }

    public static byte[] vintToBytes(long vint) {
        long i = vint;
        int size = WritableUtils.getVIntSize((long)i);
        byte[] result = new byte[size];
        int offset = 0;
        if (i >= -112L && i <= 127L) {
            result[offset] = (byte)i;
            return result;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        result[offset++] = (byte)len;
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            result[offset++] = (byte)((i & mask) >> shiftbits);
        }
        return result;
    }

    public static long bytesToVlong(byte[] buffer) {
        byte firstByte;
        int len;
        int offset = 0;
        if ((len = WritableUtils.decodeVIntSize((byte)(firstByte = buffer[offset++]))) == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = buffer[offset++];
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int bytesToVint(byte[] buffer) {
        byte firstByte;
        int len;
        int offset = 0;
        if ((len = WritableUtils.decodeVIntSize((byte)(firstByte = buffer[offset++]))) == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = buffer[offset++];
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return (int)(WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i);
    }

    public static long readVLong(byte[] buffer, int offset) throws IOException {
        byte firstByte = buffer[offset];
        int len = WritableUtils.decodeVIntSize((byte)firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = buffer[offset + 1 + idx];
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int compareTo(byte[] left, byte[] right) {
        return ByteUtils.compareTo(left, 0, left.length, right, 0, right.length);
    }

    public static int compareTo(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int end1 = s1 + l1;
        int end2 = s2 + l2;
        int i = s1;
        for (int j = s2; i < end1 && j < end2; ++i, ++j) {
            int a = b1[i] & 0xFF;
            int b = b2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return l1 - l2;
    }

    public static boolean equals(byte[] left, byte[] right) {
        return left == null && right == null ? true : (left == null || right == null || left.length != right.length ? false : ByteUtils.compareTo(left, right) == 0);
    }

    public static <T> T fromBytes(byte[] val, Schema schema, SpecificDatumReader<T> datumReader, T object) throws IOException {
        Schema.Type type = schema.getType();
        switch (type) {
            case ENUM: {
                String symbol = (String)schema.getEnumSymbols().get(val[0]);
                return Enum.valueOf(ReflectData.get().getClass(schema), symbol);
            }
            case STRING: {
                return (T)new Utf8(ByteUtils.toString(val));
            }
            case BYTES: {
                return (T)ByteBuffer.wrap(val);
            }
            case INT: {
                return (T)Integer.valueOf(ByteUtils.bytesToVint(val));
            }
            case LONG: {
                return (T)Long.valueOf(ByteUtils.bytesToVlong(val));
            }
            case FLOAT: {
                return (T)Float.valueOf(ByteUtils.toFloat(val));
            }
            case DOUBLE: {
                return (T)Double.valueOf(ByteUtils.toDouble(val));
            }
            case BOOLEAN: {
                return (T)Boolean.valueOf(val[0] != 0);
            }
            case RECORD: 
            case MAP: 
            case ARRAY: {
                return (T)IOUtils.deserialize(val, datumReader, schema, (SpecificRecord)object);
            }
        }
        throw new RuntimeException("Unknown type: " + type);
    }

    public static <T> byte[] toBytes(T o, Schema schema, SpecificDatumWriter<T> datumWriter) throws IOException {
        Schema.Type type = schema.getType();
        switch (type) {
            case STRING: {
                return ByteUtils.toBytes(((Utf8)o).toString());
            }
            case BYTES: {
                return ((ByteBuffer)o).array();
            }
            case INT: {
                return ByteUtils.vintToBytes(((Integer)o).intValue());
            }
            case LONG: {
                return ByteUtils.vintToBytes((Long)o);
            }
            case FLOAT: {
                return ByteUtils.toBytes(((Float)o).floatValue());
            }
            case DOUBLE: {
                return ByteUtils.toBytes((Double)o);
            }
            case BOOLEAN: {
                byte[] byArray;
                if (((Boolean)o).booleanValue()) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 1;
                } else {
                    byte[] byArray3 = new byte[1];
                    byArray = byArray3;
                    byArray3[0] = 0;
                }
                return byArray;
            }
            case ENUM: {
                return new byte[]{(byte)((Enum)o).ordinal()};
            }
            case RECORD: 
            case MAP: 
            case ARRAY: {
                return IOUtils.serialize(datumWriter, schema, (SpecificRecord)o);
            }
        }
        throw new RuntimeException("Unknown type: " + type);
    }
}

