/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.store.ws.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.ws.impl.WSDataStoreBase;
import org.apache.gora.util.ClassLoadingUtils;
import org.apache.gora.util.GoraException;
import org.apache.gora.util.ReflectionUtils;
import org.apache.gora.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSDataStoreFactory {
    public static final Logger log = LoggerFactory.getLogger(WSDataStoreFactory.class);
    public static final String GORA_DEFAULT_PROPERTIES_FILE = "gora.properties";
    public static final String GORA_DEFAULT_DATASTORE_KEY = "gora.datastore.default";
    public static final String GORA = "gora";
    public static final String DATASTORE = "datastore";
    private static final String GORA_DATASTORE = "gora.datastore.";
    public static final String AUTO_CREATE_SCHEMA = "autocreateschema";
    public static final String INPUT_PATH = "input.path";
    public static final String OUTPUT_PATH = "output.path";
    public static final String MAPPING_FILE = "mapping.file";
    public static final String SCHEMA_NAME = "schema.name";
    @Deprecated
    public static final Properties properties = WSDataStoreFactory.createProps();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties createProps() {
        try {
            Properties properties = new Properties();
            InputStream stream = WSDataStoreFactory.class.getClassLoader().getResourceAsStream(GORA_DEFAULT_PROPERTIES_FILE);
            if (stream == null) {
                log.warn("gora.properties not found, properties will be empty.");
                return properties;
            }
            try {
                properties.load(stream);
                Properties properties2 = properties;
                return properties2;
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private WSDataStoreFactory() {
    }

    private static <K, T extends Persistent> void initializeDataStore(DataStore<K, T> dataStore, Class<K> keyClass, Class<T> persistent, Properties properties) throws IOException, Exception {
        dataStore.initialize(keyClass, persistent, properties);
    }

    public static <D extends DataStore<K, T>, K, T extends Persistent> D createDataStore(Class<D> dataStoreClass, Class<K> keyClass, Class<T> persistent, Object auth) throws GoraException {
        return WSDataStoreFactory.createDataStore(dataStoreClass, keyClass, persistent, auth, WSDataStoreFactory.createProps(), null);
    }

    public static <D extends DataStore<K, T>, K, T extends Persistent> D createDataStore(Class<D> dataStoreClass, Class<K> keyClass, Class<T> persistent, Object auth, String schemaName) throws GoraException {
        return WSDataStoreFactory.createDataStore(dataStoreClass, keyClass, persistent, auth, WSDataStoreFactory.createProps(), schemaName);
    }

    public static <D extends DataStore<K, T>, K, T extends Persistent> D createDataStore(Class<D> dataStoreClass, Class<K> keyClass, Class<T> persistent, Object auth, Properties properties, String schemaName) throws GoraException {
        try {
            WSDataStoreFactory.setDefaultSchemaName(properties, schemaName);
            DataStore dataStore = (DataStore)ReflectionUtils.newInstance(dataStoreClass);
            if (auth != null) {
                ((WSDataStoreBase)dataStore).setConf(auth);
            }
            WSDataStoreFactory.initializeDataStore(dataStore, keyClass, persistent, properties);
            return (D)dataStore;
        }
        catch (GoraException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GoraException(ex);
        }
    }

    public static <D extends DataStore<K, T>, K, T extends Persistent> D createDataStore(Class<D> dataStoreClass, Class<K> keyClass, Class<T> persistent, Object auth, Properties properties) throws GoraException {
        return WSDataStoreFactory.createDataStore(dataStoreClass, keyClass, persistent, auth, properties, null);
    }

    public static <D extends DataStore<K, T>, K, T extends Persistent> D getDataStore(Class<D> dataStoreClass, Class<K> keyClass, Class<T> persistentClass, Object auth) throws GoraException {
        return WSDataStoreFactory.createDataStore(dataStoreClass, keyClass, persistentClass, auth, WSDataStoreFactory.createProps(), null);
    }

    public static <K, T extends Persistent> DataStore<K, T> getDataStore(String dataStoreClass, Class<K> keyClass, Class<T> persistentClass, Object auth) throws GoraException {
        try {
            Class<?> c = Class.forName(dataStoreClass);
            return WSDataStoreFactory.createDataStore(c, keyClass, persistentClass, auth, WSDataStoreFactory.createProps(), null);
        }
        catch (GoraException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GoraException(ex);
        }
    }

    public static <K, T extends Persistent> DataStore<K, T> getDataStore(String dataStoreClass, String keyClass, String persistentClass, Object auth) throws GoraException {
        try {
            Class<?> c = Class.forName(dataStoreClass);
            Class<?> k = ClassLoadingUtils.loadClass(keyClass);
            Class<?> p = ClassLoadingUtils.loadClass(persistentClass);
            return WSDataStoreFactory.createDataStore(c, k, p, auth, WSDataStoreFactory.createProps(), null);
        }
        catch (GoraException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GoraException(ex);
        }
    }

    public static <K, T extends Persistent> DataStore<K, T> getDataStore(Class<K> keyClass, Class<T> persistent, Object auth) throws GoraException {
        Class<?> c;
        Properties createProps = WSDataStoreFactory.createProps();
        try {
            c = Class.forName(WSDataStoreFactory.getDefaultDataStore(createProps));
        }
        catch (Exception ex) {
            throw new GoraException(ex);
        }
        return WSDataStoreFactory.createDataStore(c, keyClass, persistent, auth, createProps, null);
    }

    public static String findProperty(Properties properties, DataStore<?, ?> store, String baseKey, String defaultValue) {
        String fullKey;
        String value;
        Class<?> clazz = store.getClass();
        do {
            if ((value = WSDataStoreFactory.getProperty(properties, fullKey = "gora." + StringUtils.getClassname(clazz) + "." + baseKey)) != null) {
                return value;
            }
            value = WSDataStoreFactory.getProperty(properties, fullKey.toLowerCase());
            if (value == null) continue;
            return value;
        } while (!clazz.equals(WSDataStoreBase.class) && (clazz = clazz.getSuperclass()) != null);
        fullKey = GORA_DATASTORE + baseKey;
        value = WSDataStoreFactory.getProperty(properties, fullKey);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static String findPropertyOrDie(Properties properties, DataStore<?, ?> store, String baseKey) throws IOException {
        String val = WSDataStoreFactory.findProperty(properties, store, baseKey, null);
        if (val == null) {
            throw new IOException("Property with base name \"" + baseKey + "\" could not be found, make " + "sure to include this property in gora.properties file");
        }
        return val;
    }

    public static boolean findBooleanProperty(Properties properties, DataStore<?, ?> store, String baseKey, String defaultValue) {
        return Boolean.parseBoolean(WSDataStoreFactory.findProperty(properties, store, baseKey, defaultValue));
    }

    public static boolean getAutoCreateSchema(Properties properties, DataStore<?, ?> store) {
        return WSDataStoreFactory.findBooleanProperty(properties, store, AUTO_CREATE_SCHEMA, "true");
    }

    public static String getInputPath(Properties properties, DataStore<?, ?> store) {
        return WSDataStoreFactory.findProperty(properties, store, INPUT_PATH, null);
    }

    public static String getOutputPath(Properties properties, DataStore<?, ?> store) {
        return WSDataStoreFactory.findProperty(properties, store, OUTPUT_PATH, null);
    }

    public static String getMappingFile(Properties properties, DataStore<?, ?> store, String defaultValue) {
        return WSDataStoreFactory.findProperty(properties, store, MAPPING_FILE, defaultValue);
    }

    private static String getDefaultDataStore(Properties properties) {
        return WSDataStoreFactory.getProperty(properties, GORA_DEFAULT_DATASTORE_KEY);
    }

    private static String getProperty(Properties properties, String key) {
        return WSDataStoreFactory.getProperty(properties, key, null);
    }

    private static String getProperty(Properties properties, String key, String defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        String result = properties.getProperty(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    private static void setProperty(Properties properties, String baseKey, String value) {
        if (value != null) {
            properties.setProperty(GORA_DATASTORE + baseKey, value);
        }
    }

    private static <D extends DataStore<K, T>, K, T extends Persistent> void setProperty(Properties properties, Class<D> dataStoreClass, String baseKey, String value) {
        properties.setProperty("gora." + StringUtils.getClassname(dataStoreClass) + "." + baseKey, value);
    }

    public static String getDefaultSchemaName(Properties properties, DataStore<?, ?> store) {
        return WSDataStoreFactory.findProperty(properties, store, SCHEMA_NAME, null);
    }

    public static void setDefaultSchemaName(Properties properties, String schemaName) {
        if (schemaName != null) {
            WSDataStoreFactory.setProperty(properties, SCHEMA_NAME, schemaName);
        }
    }

    public static <D extends DataStore<K, T>, K, T extends Persistent> void setDefaultSchemaName(Properties properties, Class<D> dataStoreClass, String schemaName) {
        WSDataStoreFactory.setProperty(properties, dataStoreClass, SCHEMA_NAME, schemaName);
    }
}

