/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.store.ws.impl;

import java.util.Properties;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.ws.impl.WSDataStoreFactory;
import org.apache.gora.util.StringUtils;

public abstract class WSDataStoreBase<K, T extends Persistent>
implements DataStore<K, T> {
    protected Class<K> keyClass;
    protected Class<T> persistentClass;
    private String wsProvider;
    protected Object authentication;
    protected Properties properties;

    @Override
    public void initialize(Class<K> keyClass, Class<T> persistentClass, Properties properties) {
        this.setKeyClass(keyClass);
        this.setPersistentClass(persistentClass);
    }

    @Override
    public void setPersistentClass(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    @Override
    public Class<T> getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public Class<K> getKeyClass() {
        return this.keyClass;
    }

    @Override
    public void setKeyClass(Class<K> keyClass) {
        if (keyClass != null) {
            this.keyClass = keyClass;
        }
    }

    public Object getConf() {
        return this.authentication;
    }

    public void setConf(Object auth) {
        this.authentication = auth;
    }

    public void readFields(Object obj) throws Exception {
    }

    public void write(Object obj) throws Exception {
    }

    public boolean equals(Object obj) {
        if (obj instanceof WSDataStoreBase) {
            WSDataStoreBase that = (WSDataStoreBase)obj;
            return that.equals(this);
        }
        return false;
    }

    @Override
    public void truncateSchema() {
        this.deleteSchema();
        this.createSchema();
    }

    protected String getSchemaName(String mappingSchemaName, Class<?> persistentClass) {
        String schemaName = WSDataStoreFactory.getDefaultSchemaName(this.properties, this);
        if (schemaName != null) {
            return schemaName;
        }
        if (mappingSchemaName != null) {
            return mappingSchemaName;
        }
        return StringUtils.getClassname(persistentClass);
    }

    public String getWSProvider() {
        return this.wsProvider;
    }

    public void setWsProvider(String wsProvider) {
        this.wsProvider = wsProvider;
    }
}

