/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.store.impl;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.gora.avro.store.AvroStore;
import org.apache.gora.persistency.BeanFactory;
import org.apache.gora.persistency.impl.BeanFactoryImpl;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.util.AvroUtils;
import org.apache.gora.util.ClassLoadingUtils;
import org.apache.gora.util.StringUtils;
import org.apache.gora.util.WritableUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataStoreBase<K, T extends PersistentBase>
implements DataStore<K, T>,
Configurable,
Writable,
Closeable {
    protected BeanFactory<K, T> beanFactory;
    protected Class<K> keyClass;
    protected Class<T> persistentClass;
    protected Schema schema;
    protected Map<String, Schema.Field> fieldMap;
    protected Configuration conf;
    protected boolean autoCreateSchema;
    protected Properties properties;
    protected SpecificDatumReader<T> datumReader;
    protected SpecificDatumWriter<T> datumWriter;
    public static final Logger LOG = LoggerFactory.getLogger(AvroStore.class);

    @Override
    public void initialize(Class<K> keyClass, Class<T> persistentClass, Properties properties) {
        this.setKeyClass(keyClass);
        this.setPersistentClass(persistentClass);
        if (this.beanFactory == null) {
            this.beanFactory = new BeanFactoryImpl<K, T>(keyClass, persistentClass);
        }
        this.schema = ((PersistentBase)this.beanFactory.getCachedPersistent()).getSchema();
        this.fieldMap = AvroUtils.getFieldMap(this.schema);
        this.autoCreateSchema = DataStoreFactory.getAutoCreateSchema(properties, this);
        this.properties = properties;
        this.datumReader = new SpecificDatumReader(this.schema);
        this.datumWriter = new SpecificDatumWriter(this.schema);
    }

    @Override
    public void setPersistentClass(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    @Override
    public Class<T> getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public Class<K> getKeyClass() {
        return this.keyClass;
    }

    @Override
    public void setKeyClass(Class<K> keyClass) {
        if (keyClass != null) {
            this.keyClass = keyClass;
        }
    }

    @Override
    public K newKey() {
        try {
            return this.beanFactory.newKey();
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
            return null;
        }
    }

    @Override
    public T newPersistent() {
        try {
            return (T)((PersistentBase)this.beanFactory.newPersistent());
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
            return null;
        }
    }

    @Override
    public void setBeanFactory(BeanFactory<K, T> beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public BeanFactory<K, T> getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    public T get(K key) {
        return (T)((PersistentBase)this.get(key, this.getFieldsToQuery(null)));
    }

    protected String[] getFieldsToQuery(String[] fields) {
        if (fields != null) {
            return fields;
        }
        return this.getFields();
    }

    protected String[] getFields() {
        ArrayList<Schema.Field> schemaFields = ((PersistentBase)this.beanFactory.getCachedPersistent()).getSchema().getFields();
        ArrayList<Schema.Field> list = new ArrayList<Schema.Field>();
        for (Schema.Field field : schemaFields) {
            if ("__g__dirty".equalsIgnoreCase(field.name())) continue;
            list.add(field);
        }
        schemaFields = list;
        String[] fieldNames = new String[schemaFields.size()];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = ((Schema.Field)schemaFields.get(i)).name();
        }
        return fieldNames;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    protected Configuration getOrCreateConf() {
        if (this.conf == null) {
            this.conf = new Configuration();
        }
        return this.conf;
    }

    public void readFields(DataInput in) {
        try {
            Class<?> keyClass = ClassLoadingUtils.loadClass(Text.readString((DataInput)in));
            Class<?> persistentClass = ClassLoadingUtils.loadClass(Text.readString((DataInput)in));
            Properties props = WritableUtils.readProperties(in);
            this.initialize(keyClass, persistentClass, props);
        }
        catch (ClassNotFoundException ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
    }

    public void write(DataOutput out) {
        try {
            Text.writeString((DataOutput)out, (String)this.getKeyClass().getCanonicalName());
            Text.writeString((DataOutput)out, (String)this.getPersistentClass().getCanonicalName());
            WritableUtils.writeProperties(out, this.properties);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            LOG.error(e.getStackTrace().toString());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataStoreBase) {
            DataStoreBase that = (DataStoreBase)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append(this.keyClass, that.keyClass);
            builder.append(this.persistentClass, that.persistentClass);
            return builder.isEquals();
        }
        return false;
    }

    @Override
    public void truncateSchema() {
        this.deleteSchema();
        this.createSchema();
    }

    protected String getSchemaName(String mappingSchemaName, Class<?> persistentClass) {
        String confSchemaName = this.getOrCreateConf().get("preferred.schema.name");
        if (confSchemaName != null) {
            return confSchemaName;
        }
        String schemaName = DataStoreFactory.getDefaultSchemaName(this.properties, this);
        if (schemaName != null) {
            return schemaName;
        }
        if (mappingSchemaName != null) {
            return mappingSchemaName;
        }
        return StringUtils.getClassname(persistentClass);
    }
}

