/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.shims.hadoop;

import java.util.HashMap;
import java.util.Map;
import org.apache.gora.shims.hadoop.HadoopShim;
import org.apache.hadoop.util.VersionInfo;

public class HadoopShimFactory {
    private static final Map<String, String> HADOOP_VERSION_TO_IMPL_MAP = new HashMap<String, String>();

    public static HadoopShimFactory INSTANCE() {
        return Singleton.INSTANCE;
    }

    public HadoopShim getHadoopShim() {
        String version = this.getMajorVersion();
        String className = HADOOP_VERSION_TO_IMPL_MAP.get(version);
        try {
            Class<?> class1 = Class.forName(className);
            return (HadoopShim)HadoopShim.class.cast(class1.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load Hadoop shim for version " + version + ", className=" + className, e);
        }
    }

    public String getMajorVersion() {
        String vers = VersionInfo.getVersion();
        String[] parts = vers.split("\\.");
        if (parts.length < 2) {
            throw new RuntimeException("Unable to parse Hadoop version: " + vers + " (expected X.Y.* format)");
        }
        return parts[0];
    }

    HadoopShimFactory() {
    }

    static {
        HADOOP_VERSION_TO_IMPL_MAP.put("1", "org.apache.gora.shims.hadoop1.HadoopShim1");
        HADOOP_VERSION_TO_IMPL_MAP.put("2", "org.apache.gora.shims.hadoop2.HadoopShim2");
    }

    static class Singleton {
        public static final HadoopShimFactory INSTANCE = new HadoopShimFactory();

        Singleton() {
        }
    }
}

