/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.query.impl;

import java.io.IOException;
import org.apache.gora.filter.Filter;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.store.DataStore;

public abstract class ResultBase<K, T extends Persistent>
implements Result<K, T> {
    protected final DataStore<K, T> dataStore;
    protected final Query<K, T> query;
    protected K key;
    protected T persistent;
    protected long limit;
    protected long offset = 0L;

    public ResultBase(DataStore<K, T> dataStore, Query<K, T> query) {
        this.dataStore = dataStore;
        this.query = query;
        this.limit = query.getLimit();
    }

    @Override
    public DataStore<K, T> getDataStore() {
        return this.dataStore;
    }

    @Override
    public Query<K, T> getQuery() {
        return this.query;
    }

    @Override
    public T get() {
        return this.persistent;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public Class<K> getKeyClass() {
        return this.getDataStore().getKeyClass();
    }

    @Override
    public Class<T> getPersistentClass() {
        return this.getDataStore().getPersistentClass();
    }

    protected boolean isLimitReached() {
        return this.limit > 0L && this.offset >= this.limit;
    }

    protected void clear() {
        if (this.persistent != null) {
            this.persistent.clear();
        }
        if (this.key != null && this.key instanceof Persistent) {
            ((Persistent)this.key).clear();
        }
    }

    @Override
    public final boolean next() throws Exception, IOException {
        boolean ret;
        if (this.isLimitReached()) {
            return false;
        }
        do {
            this.clear();
            this.persistent = this.getOrCreatePersistent(this.persistent);
        } while ((ret = this.nextInner()) && this.filter(this.key, this.persistent));
        if (ret) {
            ++this.offset;
        }
        return ret;
    }

    protected boolean filter(K key, T persistent) {
        if (!this.query.isLocalFilterEnabled()) {
            return false;
        }
        Filter<K, T> filter = this.query.getFilter();
        if (filter == null) {
            return false;
        }
        return filter.filter(key, persistent);
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    protected abstract boolean nextInner() throws IOException;

    protected T getOrCreatePersistent(T persistent) throws Exception, IOException {
        if (persistent != null) {
            return persistent;
        }
        return this.dataStore.newPersistent();
    }

    @Override
    public void close() throws IOException {
    }
}

