/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.persistency.ws.impl;

import java.lang.reflect.Constructor;
import org.apache.gora.persistency.BeanFactory;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.util.ReflectionUtils;

public class BeanFactoryWSImpl<K, T extends Persistent>
implements BeanFactory<K, T> {
    private Class<K> keyClass;
    private Class<T> persistentClass;
    private Constructor<K> keyConstructor;
    private K key;
    private T persistent;
    private boolean isKeyPersistent = false;

    public BeanFactoryWSImpl(Class<K> keyClass, Class<T> persistentClass) {
        this.keyClass = keyClass;
        this.persistentClass = persistentClass;
        try {
            if (ReflectionUtils.hasConstructor(keyClass)) {
                this.keyConstructor = ReflectionUtils.getConstructor(keyClass);
                this.key = this.keyConstructor.newInstance(ReflectionUtils.EMPTY_OBJECT_ARRAY);
            }
            this.persistent = (Persistent)ReflectionUtils.newInstance(persistentClass);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.isKeyPersistent = Persistent.class.isAssignableFrom(keyClass);
    }

    @Override
    public K newKey() throws Exception {
        if (this.isKeyPersistent) {
            return this.keyClass.newInstance();
        }
        if (this.keyConstructor == null) {
            throw new RuntimeException("Key class does not have a no-arg constructor");
        }
        return this.keyConstructor.newInstance(ReflectionUtils.EMPTY_OBJECT_ARRAY);
    }

    @Override
    public T newPersistent() {
        try {
            return (T)((Persistent)this.persistentClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public K getCachedKey() {
        return this.key;
    }

    @Override
    public T getCachedPersistent() {
        return this.persistent;
    }

    @Override
    public Class<K> getKeyClass() {
        return this.keyClass;
    }

    @Override
    public Class<T> getPersistentClass() {
        return this.persistentClass;
    }

    public boolean isKeyPersistent() {
        return this.isKeyPersistent;
    }
}

