/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.persistency.impl;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.gora.persistency.Dirtyable;
import org.apache.gora.persistency.Persistent;

public abstract class PersistentBase
extends SpecificRecordBase
implements Persistent {
    private ByteBuffer __g__dirty = ByteBuffer.wrap(new byte[this.getFieldsCount()]);

    public abstract int getFieldsCount();

    @Override
    public void clearDirty() {
        ByteBuffer dirtyBytes = this.getDirtyBytes();
        assert (dirtyBytes.position() == 0);
        for (int i = 0; i < dirtyBytes.limit(); ++i) {
            dirtyBytes.put(i, (byte)0);
        }
        for (Schema.Field field : this.getSchema().getFields()) {
            this.clearDirynessIfFieldIsDirtyable(field.pos());
        }
    }

    private void clearDirynessIfFieldIsDirtyable(int fieldIndex) {
        if (fieldIndex == 0) {
            return;
        }
        Object value = this.get(fieldIndex);
        if (value instanceof Dirtyable) {
            ((Dirtyable)value).clearDirty();
        }
    }

    @Override
    public void clearDirty(int fieldIndex) {
        ByteBuffer dirtyBytes = this.getDirtyBytes();
        assert (dirtyBytes.position() == 0);
        int byteOffset = fieldIndex / 8;
        int bitOffset = fieldIndex % 8;
        byte currentByte = dirtyBytes.get(byteOffset);
        currentByte = (byte)(~(1 << bitOffset) & currentByte);
        dirtyBytes.put(byteOffset, currentByte);
        this.clearDirynessIfFieldIsDirtyable(fieldIndex);
    }

    @Override
    public void clearDirty(String field) {
        this.clearDirty(this.getSchema().getField(field).pos());
    }

    @Override
    public boolean isDirty() {
        List fields = this.getSchema().getFields();
        boolean isSubRecordDirty = false;
        for (Schema.Field field : fields) {
            isSubRecordDirty = isSubRecordDirty || this.checkIfMutableFieldAndDirty(field);
        }
        ByteBuffer dirtyBytes = this.getDirtyBytes();
        assert (dirtyBytes.position() == 0);
        boolean dirty = false;
        for (int i = 0; i < dirtyBytes.limit(); ++i) {
            dirty = dirty || dirtyBytes.get(i) != 0;
        }
        return isSubRecordDirty || dirty;
    }

    private boolean checkIfMutableFieldAndDirty(Schema.Field field) {
        if (field.pos() == 0) {
            return false;
        }
        switch (field.schema().getType()) {
            case RECORD: 
            case MAP: 
            case ARRAY: {
                Object value = this.get(field.pos());
                return !(value instanceof Dirtyable) || value == null ? false : ((Dirtyable)value).isDirty();
            }
            case UNION: {
                Object value = this.get(field.pos());
                return !(value instanceof Dirtyable) || value == null ? false : ((Dirtyable)value).isDirty();
            }
        }
        return false;
    }

    @Override
    public boolean isDirty(int fieldIndex) {
        Schema.Field field = (Schema.Field)this.getSchema().getFields().get(fieldIndex);
        boolean isSubRecordDirty = this.checkIfMutableFieldAndDirty(field);
        ByteBuffer dirtyBytes = this.getDirtyBytes();
        assert (dirtyBytes.position() == 0);
        int byteOffset = fieldIndex / 8;
        int bitOffset = fieldIndex % 8;
        byte currentByte = dirtyBytes.get(byteOffset);
        return isSubRecordDirty || 0 != (1 << bitOffset & currentByte);
    }

    @Override
    public boolean isDirty(String fieldName) {
        Schema.Field field = this.getSchema().getField(fieldName);
        if (field == null) {
            throw new IndexOutOfBoundsException("Field " + fieldName + " does not exist in this schema.");
        }
        return this.isDirty(field.pos());
    }

    @Override
    public void setDirty() {
        ByteBuffer dirtyBytes = this.getDirtyBytes();
        assert (dirtyBytes.position() == 0);
        for (int i = 0; i < dirtyBytes.limit(); ++i) {
            dirtyBytes.put(i, (byte)-128);
        }
    }

    @Override
    public void setDirty(int fieldIndex) {
        ByteBuffer dirtyBytes = this.getDirtyBytes();
        assert (dirtyBytes.position() == 0);
        int byteOffset = fieldIndex / 8;
        int bitOffset = fieldIndex % 8;
        byte currentByte = dirtyBytes.get(byteOffset);
        currentByte = (byte)(1 << bitOffset | currentByte);
        dirtyBytes.put(byteOffset, currentByte);
    }

    @Override
    public void setDirty(String field) {
        this.setDirty(this.getSchema().getField(field).pos());
    }

    private ByteBuffer getDirtyBytes() {
        return this.__g__dirty;
    }

    @Override
    public void clear() {
        List<Schema.Field> unmanagedFields = this.getUnmanagedFields();
        for (Schema.Field field : this.getSchema().getFields()) {
            if (!unmanagedFields.contains(field)) continue;
            this.put(field.pos(), PersistentData.get().deepCopy(field.schema(), PersistentData.get().getDefaultValue(field)));
        }
        this.clearDirty();
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that instanceof Persistent) {
            return PersistentData.get().equals(this, (SpecificRecord)that);
        }
        return false;
    }

    @Override
    public List<Schema.Field> getUnmanagedFields() {
        List fields = this.getSchema().getFields();
        return fields;
    }

    public static class PersistentData
    extends SpecificData {
        private static final PersistentData INSTANCE = new PersistentData();

        public static PersistentData get() {
            return INSTANCE;
        }

        public boolean equals(SpecificRecord obj1, SpecificRecord that) {
            if (that == obj1) {
                return true;
            }
            if (!(that instanceof SpecificRecord)) {
                return false;
            }
            if (obj1.getClass() != that.getClass()) {
                return false;
            }
            return PersistentData.get().compare(obj1, that, obj1.getSchema(), true) == 0;
        }
    }
}

