/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.persistency.impl;

import java.util.ListIterator;
import org.apache.gora.persistency.impl.DirtyFlag;

final class DirtyListIterator<T>
implements ListIterator<T> {
    private final ListIterator<T> iteratorDelegate;
    private final DirtyFlag dirtyFlag;

    DirtyListIterator(ListIterator<T> delegate, DirtyFlag dirtyFlag) {
        this.iteratorDelegate = delegate;
        this.dirtyFlag = dirtyFlag;
    }

    @Override
    public boolean hasNext() {
        return this.iteratorDelegate.hasNext();
    }

    @Override
    public T next() {
        return this.iteratorDelegate.next();
    }

    @Override
    public boolean hasPrevious() {
        return this.iteratorDelegate.hasPrevious();
    }

    @Override
    public T previous() {
        return this.iteratorDelegate.previous();
    }

    @Override
    public int nextIndex() {
        return this.iteratorDelegate.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.iteratorDelegate.previousIndex();
    }

    @Override
    public void remove() {
        this.dirtyFlag.makeDirty(true);
        this.iteratorDelegate.remove();
    }

    @Override
    public void set(T e) {
        this.dirtyFlag.makeDirty(true);
        this.iteratorDelegate.set(e);
    }

    @Override
    public void add(T e) {
        this.dirtyFlag.makeDirty(true);
        this.iteratorDelegate.add(e);
    }
}

