/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.memory.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.avro.Schema;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.PartitionQueryImpl;
import org.apache.gora.query.impl.QueryBase;
import org.apache.gora.query.impl.ResultBase;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.impl.DataStoreBase;
import org.apache.gora.util.AvroUtils;

public class MemStore<K, T extends PersistentBase>
extends DataStoreBase<K, T> {
    private TreeMap<K, T> map = new TreeMap();

    @Override
    public String getSchemaName() {
        return "default";
    }

    @Override
    public boolean delete(K key) {
        return this.map.remove(key) != null;
    }

    @Override
    public long deleteByQuery(Query<K, T> query) {
        try {
            long deletedRows = 0L;
            Result<K, T> result = query.execute();
            while (result.next()) {
                if (!this.delete(result.getKey())) continue;
                ++deletedRows;
            }
            return 0L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public Result<K, T> execute(Query<K, T> query) {
        K startKey = query.getStartKey();
        K endKey = query.getEndKey();
        if (startKey == null) {
            startKey = this.map.firstKey();
        }
        if (endKey == null) {
            endKey = this.map.lastKey();
        }
        query.setFields(this.getFieldsToQuery(query.getFields()));
        NavigableMap<K, T> submap = this.map.subMap(startKey, true, endKey, true);
        return new MemResult<K, T>(this, query, submap);
    }

    @Override
    public T get(K key, String[] fields) {
        PersistentBase obj = (PersistentBase)this.map.get(key);
        if (obj == null) {
            return null;
        }
        return (T)MemStore.getPersistent(obj, this.getFieldsToQuery(fields));
    }

    private static <T extends Persistent> T getPersistent(T obj, String[] fields) {
        List otherFields = obj.getSchema().getFields();
        Object[] otherFieldStrings = new String[otherFields.size()];
        for (int i = 0; i < otherFields.size(); ++i) {
            otherFieldStrings[i] = ((Schema.Field)otherFields.get(i)).name();
        }
        if (Arrays.equals(fields, otherFieldStrings)) {
            return obj;
        }
        T newObj = AvroUtils.deepClonePersistent(obj);
        for (int i = 0; i < otherFields.size(); ++i) {
            int index = ((Schema.Field)otherFields.get(i)).pos();
            newObj.put(index, obj.get(index));
        }
        return newObj;
    }

    @Override
    public Query<K, T> newQuery() {
        return new MemQuery(this);
    }

    @Override
    public void put(K key, T obj) {
        this.map.put(key, obj);
    }

    @Override
    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> query) {
        ArrayList<PartitionQuery<K, T>> list = new ArrayList<PartitionQuery<K, T>>();
        PartitionQueryImpl<K, T> pqi = new PartitionQueryImpl<K, T>(query, new String[0]);
        pqi.setConf(this.getConf());
        list.add(pqi);
        return list;
    }

    @Override
    public void close() {
        this.map.clear();
    }

    @Override
    public void createSchema() {
    }

    @Override
    public void deleteSchema() {
        this.map.clear();
    }

    @Override
    public boolean schemaExists() {
        return true;
    }

    @Override
    public void flush() {
    }

    public static class MemResult<K, T extends PersistentBase>
    extends ResultBase<K, T> {
        private NavigableMap<K, T> map;
        private Iterator<K> iterator;

        public MemResult(DataStore<K, T> dataStore, Query<K, T> query, NavigableMap<K, T> map) {
            super(dataStore, query);
            this.map = map;
            this.iterator = map.navigableKeySet().iterator();
        }

        @Override
        public void close() {
        }

        @Override
        public float getProgress() throws IOException {
            return 0.0f;
        }

        @Override
        protected void clear() {
        }

        @Override
        public boolean nextInner() throws IOException {
            if (!this.iterator.hasNext()) {
                return false;
            }
            this.key = this.iterator.next();
            this.persistent = (Persistent)this.map.get(this.key);
            return true;
        }
    }

    public static class MemQuery<K, T extends PersistentBase>
    extends QueryBase<K, T> {
        public MemQuery() {
            super(null);
        }

        public MemQuery(DataStore<K, T> dataStore) {
            super(dataStore);
        }
    }
}

