/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.util.AvroUtils;
import org.apache.hadoop.io.serializer.Deserializer;

public class PersistentDeserializer
implements Deserializer<Persistent> {
    private BinaryDecoder decoder;
    private Class<? extends Persistent> persistentClass;
    private boolean reuseObjects;
    private SpecificDatumReader<Persistent> datumReader;

    public PersistentDeserializer(Class<? extends Persistent> c, boolean reuseObjects) {
        this.persistentClass = c;
        this.reuseObjects = reuseObjects;
        try {
            Schema schema = AvroUtils.getSchema(this.persistentClass);
            this.datumReader = new SpecificDatumReader(schema);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void open(InputStream in) throws IOException {
        this.decoder = DecoderFactory.get().directBinaryDecoder(in, this.decoder);
    }

    public void close() throws IOException {
    }

    public Persistent deserialize(Persistent persistent) throws IOException {
        return (Persistent)this.datumReader.read((Object)(this.reuseObjects ? persistent : null), (Decoder)this.decoder);
    }
}

