/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mapreduce;

import java.io.IOException;
import org.apache.gora.mapreduce.GoraRecordCounter;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.store.DataStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoraRecordWriter<K, T>
extends RecordWriter<K, T> {
    public static final Logger LOG = LoggerFactory.getLogger(GoraRecordWriter.class);
    private static final String BUFFER_LIMIT_WRITE_NAME = "gora.buffer.write.limit";
    private static final int BUFFER_LIMIT_WRITE_VALUE = 10000;
    private DataStore<K, Persistent> store;
    private GoraRecordCounter counter = new GoraRecordCounter();

    public GoraRecordWriter(DataStore<K, Persistent> store, TaskAttemptContext context) {
        this.store = store;
        Configuration configuration = context.getConfiguration();
        int recordsMax = configuration.getInt(BUFFER_LIMIT_WRITE_NAME, 10000);
        this.counter.setRecordsMax(recordsMax);
        LOG.info("gora.buffer.write.limit = " + recordsMax);
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        try {
            this.store.close();
        }
        catch (Exception e) {
            LOG.warn("Exception at GoraRecordWriter.class while closing datastore." + e.getMessage());
        }
    }

    public void write(K key, T value) throws IOException, InterruptedException {
        try {
            this.store.put(key, (Persistent)value);
            this.counter.increment();
            if (this.counter.isModulo()) {
                LOG.info("Flushing the datastore after " + this.counter.getRecordsNumber() + " records");
                this.store.flush();
            }
        }
        catch (Exception e) {
            LOG.warn("Exception at GoraRecordWriter.class while writing to datastore. " + e.getMessage());
        }
    }
}

