/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.gora.mapreduce.GoraInputSplit;
import org.apache.gora.mapreduce.GoraMapReduceUtils;
import org.apache.gora.mapreduce.GoraRecordReader;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.impl.FileSplitPartitionQuery;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.store.FileBackedDataStore;
import org.apache.gora.util.IOUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class GoraInputFormat<K, T extends PersistentBase>
extends InputFormat<K, T>
implements Configurable {
    public static final String QUERY_KEY = "gora.inputformat.query";
    private DataStore<K, T> dataStore;
    private Configuration conf;
    private Query<K, T> query;

    private void setInputPath(PartitionQuery<K, T> partitionQuery, TaskAttemptContext context) throws IOException {
        if (partitionQuery instanceof FileSplitPartitionQuery) {
            FileSplit split = ((FileSplitPartitionQuery)partitionQuery).getSplit();
            ((FileBackedDataStore)partitionQuery.getDataStore()).setInputPath(split.getPath().toString());
        }
    }

    public RecordReader<K, T> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        PartitionQuery<?, ?> partitionQuery = ((GoraInputSplit)split).getQuery();
        this.setInputPath(partitionQuery, context);
        return new GoraRecordReader(partitionQuery, context);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        List<PartitionQuery<K, T>> queries = this.dataStore.getPartitions(this.query);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(queries.size());
        for (PartitionQuery<K, T> query : queries) {
            splits.add(new GoraInputSplit(context.getConfiguration(), query));
        }
        return splits;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        try {
            this.query = this.getQuery(conf);
            this.dataStore = this.query.getDataStore();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <K, T extends Persistent> void setQuery(Job job, Query<K, T> query) throws IOException {
        IOUtils.storeToConf(query, job.getConfiguration(), QUERY_KEY);
    }

    public Query<K, T> getQuery(Configuration conf) throws IOException {
        return (Query)IOUtils.loadFromConf(conf, QUERY_KEY);
    }

    public static <K1, V1 extends Persistent> void setInput(Job job, Query<K1, V1> query, boolean reuseObjects) throws IOException {
        GoraInputFormat.setInput(job, query, query.getDataStore(), reuseObjects);
    }

    public static <K1, V1 extends Persistent> void setInput(Job job, Query<K1, V1> query, DataStore<K1, V1> dataStore, boolean reuseObjects) throws IOException {
        Configuration conf = job.getConfiguration();
        GoraMapReduceUtils.setIOSerializations(conf, reuseObjects);
        job.setInputFormatClass(GoraInputFormat.class);
        GoraInputFormat.setQuery(job, query);
    }

    public static <K1, V1 extends Persistent> void setInput(Job job, Class<? extends DataStore<K1, V1>> dataStoreClass, Class<K1> inKeyClass, Class<V1> inValueClass, boolean reuseObjects) throws IOException {
        DataStore<K1, V1> store = DataStoreFactory.getDataStore(dataStoreClass, inKeyClass, inValueClass, job.getConfiguration());
        GoraInputFormat.setInput(job, store.newQuery(), store, reuseObjects);
    }
}

