/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.gora.filter.Filter;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.util.ReflectionUtils;
import org.apache.hadoop.io.Text;

public class FilterList<K, T extends PersistentBase>
implements Filter<K, T> {
    private Operator operator = Operator.MUST_PASS_ALL;
    private List<Filter<K, T>> filters = new ArrayList<Filter<K, T>>();

    public FilterList() {
    }

    public FilterList(List<Filter<K, T>> rowFilters) {
        this.filters = rowFilters;
    }

    public FilterList(Operator operator) {
        this.operator = operator;
    }

    public FilterList(Operator operator, List<Filter<K, T>> rowFilters) {
        this.filters = rowFilters;
        this.operator = operator;
    }

    public List<Filter<K, T>> getFilters() {
        return this.filters;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void addFilter(Filter<K, T> filter) {
        this.filters.add(filter);
    }

    public void readFields(DataInput in) throws IOException {
        byte opByte = in.readByte();
        this.operator = Operator.values()[opByte];
        int size = in.readInt();
        if (size > 0) {
            this.filters = new ArrayList<Filter<K, T>>(size);
            try {
                for (int i = 0; i < size; ++i) {
                    Class<Filter> cls = Class.forName(Text.readString((DataInput)in)).asSubclass(Filter.class);
                    Filter filter = ReflectionUtils.newInstance(cls);
                    filter.readFields(in);
                    this.filters.add(filter);
                }
            }
            catch (Exception e) {
                throw (IOException)new IOException("Failed filter init").initCause(e);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.operator.ordinal());
        out.writeInt(this.filters.size());
        for (Filter<K, T> filter : this.filters) {
            Text.writeString((DataOutput)out, (String)filter.getClass().getName());
            filter.write(out);
        }
    }

    @Override
    public boolean filter(K key, T persistent) {
        return false;
    }

    public static enum Operator {
        MUST_PASS_ALL,
        MUST_PASS_ONE;

    }
}

