/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.avro.store;

import java.io.IOException;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.SeekableInput;
import org.apache.gora.avro.mapreduce.FsInput;
import org.apache.gora.avro.query.DataFileAvroResult;
import org.apache.gora.avro.store.AvroStore;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.FileSplitPartitionQuery;
import org.apache.gora.util.OperationNotSupportedException;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFileAvroStore<K, T extends PersistentBase>
extends AvroStore<K, T> {
    public static final Logger LOG = LoggerFactory.getLogger(AvroStore.class);
    private DataFileWriter<T> writer;

    @Override
    public T get(K key, String[] fields) {
        throw new OperationNotSupportedException("Avro DataFile's does not support indexed retrieval");
    }

    @Override
    public void put(K key, T obj) {
        try {
            this.getWriter().append(obj);
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
        }
    }

    private DataFileWriter<T> getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new DataFileWriter(this.getDatumWriter());
            this.writer.create(this.schema, this.getOrCreateOutputStream());
        }
        return this.writer;
    }

    @Override
    protected Result<K, T> executeQuery(Query<K, T> query) {
        try {
            return new DataFileAvroResult<K, T>(this, query, this.createReader(this.createFsInput()));
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
            return null;
        }
    }

    @Override
    protected Result<K, T> executePartial(FileSplitPartitionQuery<K, T> query) {
        try {
            FsInput fsInput = this.createFsInput();
            DataFileReader<T> reader = this.createReader(fsInput);
            return new DataFileAvroResult<K, T>(this, query, reader, fsInput, query.getStart(), query.getLength());
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
            return null;
        }
    }

    private DataFileReader<T> createReader(FsInput fsInput) throws IOException {
        return new DataFileReader((SeekableInput)fsInput, this.getDatumReader());
    }

    private FsInput createFsInput() throws IOException {
        Path path = new Path(this.getInputPath());
        return new FsInput(path, this.getConf());
    }

    @Override
    public void flush() {
        try {
            super.flush();
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
        }
    }

    @Override
    public void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = null;
            super.close();
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
            LOG.error(ex.getStackTrace().toString());
        }
    }
}

