/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.avro.query;

import java.io.IOException;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.Query;
import org.apache.gora.query.impl.ResultBase;
import org.apache.gora.store.DataStore;

public class DataFileAvroResult<K, T extends PersistentBase>
extends ResultBase<K, T> {
    private SeekableInput in;
    private DataFileReader<T> reader;
    private long start;
    private long end;

    public DataFileAvroResult(DataStore<K, T> dataStore, Query<K, T> query, DataFileReader<T> reader) throws IOException {
        this(dataStore, query, reader, null, 0L, 0L);
    }

    public DataFileAvroResult(DataStore<K, T> dataStore, Query<K, T> query, DataFileReader<T> reader, SeekableInput in, long start, long length) throws IOException {
        super(dataStore, query);
        this.reader = reader;
        this.start = start;
        this.end = start + length;
        this.in = in;
        if (start > 0L) {
            reader.sync(start);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = null;
    }

    @Override
    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.in.tell() - this.start) / (float)(this.end - this.start));
    }

    @Override
    public boolean nextInner() throws IOException {
        if (!this.reader.hasNext()) {
            return false;
        }
        if (this.end > 0L && this.reader.pastSync(this.end)) {
            return false;
        }
        this.persistent = (Persistent)this.reader.next((Object)this.persistent);
        return true;
    }
}

