/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Element;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PropertyFilteredIterable<T extends Element>
implements CloseableIterable<T> {
    private final String key;
    private final Object value;
    private final Iterable<T> iterable;

    public PropertyFilteredIterable(String key, Object value, Iterable<T> iterable) {
        this.key = key;
        this.value = value;
        this.iterable = iterable;
    }

    @Override
    public void close() {
        if (this.iterable instanceof CloseableIterable) {
            ((CloseableIterable)this.iterable).close();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Iterator<T> itty;
            private T nextElement;
            {
                this.itty = PropertyFilteredIterable.this.iterable.iterator();
                this.nextElement = null;
            }

            @Override
            public void remove() {
                this.itty.remove();
            }

            @Override
            public boolean hasNext() {
                if (null != this.nextElement) {
                    return true;
                }
                try {
                    Element element;
                    while (true) {
                        Object temp;
                        if (null != (temp = (element = (Element)this.itty.next()).getProperty(PropertyFilteredIterable.this.key))) {
                            if (!temp.equals(PropertyFilteredIterable.this.value)) continue;
                            this.nextElement = element;
                            return true;
                        }
                        if (PropertyFilteredIterable.this.value == null) break;
                    }
                    this.nextElement = element;
                    return true;
                }
                catch (NoSuchElementException e) {
                    this.nextElement = null;
                    return false;
                }
            }

            @Override
            public T next() {
                Element element;
                if (null != this.nextElement) {
                    Object temp = this.nextElement;
                    this.nextElement = null;
                    return temp;
                }
                while (!(element = (Element)this.itty.next()).getPropertyKeys().contains(PropertyFilteredIterable.this.key) || !element.getProperty(PropertyFilteredIterable.this.key).equals(PropertyFilteredIterable.this.value)) {
                }
                return element;
            }
        };
    }
}

