/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util;

import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import java.util.ArrayList;
import java.util.List;

public abstract class DefaultQuery
implements Query {
    private static final String[] EMPTY_LABELS = new String[0];
    public Direction direction = Direction.BOTH;
    public String[] labels = EMPTY_LABELS;
    public int limit = Integer.MAX_VALUE;
    public List<HasContainer> hasContainers = new ArrayList<HasContainer>();

    @Override
    public Query has(String key, Object value) {
        this.hasContainers.add(new HasContainer(key, Compare.EQUAL, value));
        return this;
    }

    @Override
    public Query hasNot(String key, Object value) {
        this.hasContainers.add(new HasContainer(key, Compare.NOT_EQUAL, value));
        return this;
    }

    @Override
    public Query hasNot(String key) {
        this.hasContainers.add(new HasContainer(key, Compare.EQUAL, null));
        return this;
    }

    @Override
    public Query has(String key) {
        this.hasContainers.add(new HasContainer(key, Compare.NOT_EQUAL, null));
        return this;
    }

    @Override
    public <T extends Comparable<T>> Query has(String key, T value, Query.Compare compare) {
        return this.has(key, compare, value);
    }

    @Override
    public Query has(String key, Predicate predicate, Object value) {
        this.hasContainers.add(new HasContainer(key, predicate, value));
        return this;
    }

    @Override
    public <T extends Comparable<?>> Query interval(String key, T startValue, T endValue) {
        this.hasContainers.add(new HasContainer(key, Compare.GREATER_THAN_EQUAL, startValue));
        this.hasContainers.add(new HasContainer(key, Compare.LESS_THAN, endValue));
        return this;
    }

    @Override
    public Query limit(int count) {
        this.limit = count;
        return this;
    }

    protected class HasContainer {
        public String key;
        public Object value;
        public Predicate predicate;

        public HasContainer(String key, Predicate predicate, Object value) {
            this.key = key;
            this.value = value;
            this.predicate = predicate;
        }

        public boolean isLegal(Element element) {
            return this.predicate.evaluate(element.getProperty(this.key), this.value);
        }
    }
}

