/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.reflectasm;

import com.esotericsoftware.reflectasm.AccessClassLoader;
import java.lang.reflect.Modifier;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConstructorAccess<T> {
    boolean isNonStaticMemberClass;

    public boolean isNonStaticMemberClass() {
        return this.isNonStaticMemberClass;
    }

    public abstract T newInstance();

    public abstract T newInstance(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ConstructorAccess<T> get(Class<T> type) {
        AccessClassLoader loader;
        Class<?> enclosingType = type.getEnclosingClass();
        boolean isNonStaticMemberClass = enclosingType != null && type.isMemberClass() && !Modifier.isStatic(type.getModifiers());
        String className = type.getName();
        String accessClassName = className + "ConstructorAccess";
        if (accessClassName.startsWith("java.")) {
            accessClassName = "reflectasm." + accessClassName;
        }
        Class<?> accessClass = null;
        AccessClassLoader accessClassLoader = loader = AccessClassLoader.get(type);
        synchronized (accessClassLoader) {
            try {
                accessClass = loader.loadClass(accessClassName);
            }
            catch (ClassNotFoundException ignored) {
                String enclosingClassNameInternal;
                String accessClassNameInternal = accessClassName.replace('.', '/');
                String classNameInternal = className.replace('.', '/');
                if (!isNonStaticMemberClass) {
                    enclosingClassNameInternal = null;
                    try {
                        type.getConstructor(null);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Class cannot be created (missing no-arg constructor): " + type.getName());
                    }
                }
                enclosingClassNameInternal = enclosingType.getName().replace('.', '/');
                try {
                    type.getConstructor(enclosingType);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Non-static member class cannot be created (missing enclosing class constructor): " + type.getName());
                }
                ClassWriter cw = new ClassWriter(0);
                cw.visit(196653, 33, accessClassNameInternal, null, "com/esotericsoftware/reflectasm/ConstructorAccess", null);
                ConstructorAccess.insertConstructor(cw);
                ConstructorAccess.insertNewInstance(cw, classNameInternal);
                ConstructorAccess.insertNewInstanceInner(cw, classNameInternal, enclosingClassNameInternal);
                cw.visitEnd();
                accessClass = loader.defineClass(accessClassName, cw.toByteArray());
            }
        }
        try {
            ConstructorAccess access = (ConstructorAccess)accessClass.newInstance();
            access.isNonStaticMemberClass = isNonStaticMemberClass;
            return access;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error constructing constructor access class: " + accessClassName, ex);
        }
    }

    private static void insertConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "com/esotericsoftware/reflectasm/ConstructorAccess", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    static void insertNewInstance(ClassWriter cw, String classNameInternal) {
        MethodVisitor mv = cw.visitMethod(1, "newInstance", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, classNameInternal);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, classNameInternal, "<init>", "()V");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    static void insertNewInstanceInner(ClassWriter cw, String classNameInternal, String enclosingClassNameInternal) {
        MethodVisitor mv = cw.visitMethod(1, "newInstance", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        if (enclosingClassNameInternal != null) {
            mv.visitTypeInsn(187, classNameInternal);
            mv.visitInsn(89);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, enclosingClassNameInternal);
            mv.visitInsn(89);
            mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
            mv.visitInsn(87);
            mv.visitMethodInsn(183, classNameInternal, "<init>", "(L" + enclosingClassNameInternal + ";)V");
            mv.visitInsn(176);
            mv.visitMaxs(4, 2);
        } else {
            mv.visitTypeInsn(187, "java/lang/UnsupportedOperationException");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)"Not an inner class.");
            mv.visitMethodInsn(183, "java/lang/UnsupportedOperationException", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
            mv.visitMaxs(3, 2);
        }
        mv.visitEnd();
    }
}

