/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.zk;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;

public class ZooKeeperNodeCreator
implements Tool,
Watcher {
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int run(String[] args) throws Exception {
        Options options = new Options();
        options.addOption("zk", "zkServer", true, "List of host:port ZooKeeper servers");
        options.addOption("n", "zkNode", true, "ZooKeeper node to create");
        HelpFormatter formatter = new HelpFormatter();
        if (args.length == 0) {
            formatter.printHelp(this.getClass().getName(), options, true);
            return 0;
        }
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        ZooKeeperExt zkExt = new ZooKeeperExt(cmd.getOptionValue("zkServer"), 30000, 5, 1000, this);
        zkExt.createExt(cmd.getOptionValue("zkNode"), new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        return 0;
    }

    public void process(WatchedEvent event) {
        System.out.println("process: ZK event received: " + event);
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new ZooKeeperNodeCreator(), (String[])args));
    }
}

