/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.zk;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.time.SystemTime;
import org.apache.giraph.time.Time;
import org.apache.giraph.zk.ComputationDoneName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;

public class ZooKeeperManager {
    private static final Logger LOG = Logger.getLogger(ZooKeeperManager.class);
    private static final String HOSTNAME_TASK_SEPARATOR = " ";
    private static final String ZOOKEEPER_SERVER_LIST_FILE_PREFIX = "zkServerList_";
    private Mapper.Context context;
    private final ImmutableClassesGiraphConfiguration conf;
    private final int taskPartition;
    private final Path baseDirectory;
    private final Path taskDirectory;
    private final Path serverDirectory;
    private final Path myClosedPath;
    private final int pollMsecs;
    private final int serverCount;
    private final FileSystem fs;
    private Process zkProcess = null;
    private StreamCollector zkProcessCollector = null;
    private final String zkDir;
    private final String configFilePath;
    private final Map<String, Integer> zkServerPortMap = Maps.newTreeMap();
    private final int zkBasePort;
    private String zkServerPortString;
    private String myHostname = null;
    private final String jobId;
    private final String zkDirDefault;
    private final Time time = SystemTime.get();

    public ZooKeeperManager(Mapper.Context context, ImmutableClassesGiraphConfiguration configuration) throws IOException {
        this.context = context;
        this.conf = configuration;
        this.taskPartition = this.conf.getTaskPartition();
        this.jobId = this.conf.get("mapred.job.id", "Unknown Job");
        this.baseDirectory = new Path(GiraphConstants.ZOOKEEPER_MANAGER_DIRECTORY.getWithDefault(this.conf, this.getFinalZooKeeperPath()));
        this.taskDirectory = new Path(this.baseDirectory, "_task");
        this.serverDirectory = new Path(this.baseDirectory, "_zkServer");
        this.myClosedPath = new Path(this.taskDirectory, new ComputationDoneName(this.taskPartition).getName());
        this.pollMsecs = GiraphConstants.ZOOKEEPER_SERVERLIST_POLL_MSECS.get(this.conf);
        this.serverCount = GiraphConstants.ZOOKEEPER_SERVER_COUNT.get(this.conf);
        String jobLocalDir = this.conf.get("job.local.dir");
        this.zkDirDefault = jobLocalDir != null ? jobLocalDir + "/_bspZooKeeper" : System.getProperty("user.dir") + "/" + GiraphConstants.ZOOKEEPER_MANAGER_DIRECTORY.getDefaultValue();
        this.zkDir = this.conf.get("giraph.zkDir", this.zkDirDefault);
        this.configFilePath = this.zkDir + "/zoo.cfg";
        this.zkBasePort = GiraphConstants.ZOOKEEPER_SERVER_PORT.get(this.conf);
        this.myHostname = this.conf.getLocalHostname();
        this.fs = FileSystem.get((Configuration)this.conf);
    }

    private String getFinalZooKeeperPath() {
        return GiraphConstants.ZOOKEEPER_MANAGER_DIRECTORY.getDefaultValue() + "/" + this.jobId;
    }

    public static String getBasePath(Configuration conf) {
        String result = conf.get("giraph.zkBaseZNode", "");
        if (!result.equals("") && !result.startsWith("/")) {
            throw new IllegalArgumentException("Value for giraph.zkBaseZNode must start with /: " + result);
        }
        return result;
    }

    public void setup() throws IOException, InterruptedException {
        this.createCandidateStamp();
        this.getZooKeeperServerList();
    }

    public void createCandidateStamp() {
        try {
            this.fs.mkdirs(this.baseDirectory);
            LOG.info((Object)("createCandidateStamp: Made the directory " + this.baseDirectory));
        }
        catch (IOException e) {
            LOG.error((Object)("createCandidateStamp: Failed to mkdirs " + this.baseDirectory));
        }
        try {
            this.fs.mkdirs(this.serverDirectory);
            LOG.info((Object)("createCandidateStamp: Made the directory " + this.serverDirectory));
        }
        catch (IOException e) {
            LOG.error((Object)("createCandidateStamp: Failed to mkdirs " + this.serverDirectory));
        }
        try {
            if (!this.fs.getFileStatus(this.baseDirectory).isDir()) {
                throw new IllegalArgumentException("createCandidateStamp: " + this.baseDirectory + " is not a directory, but should be.");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("createCandidateStamp: Couldn't get file status for base directory " + this.baseDirectory + ".  If there is an " + "issue with this directory, please set an accesible " + "base directory with the Hadoop configuration option " + GiraphConstants.ZOOKEEPER_MANAGER_DIRECTORY.getKey(), e);
        }
        Path myCandidacyPath = new Path(this.taskDirectory, this.myHostname + HOSTNAME_TASK_SEPARATOR + this.taskPartition);
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("createCandidateStamp: Creating my filestamp " + myCandidacyPath));
            }
            this.fs.createNewFile(myCandidacyPath);
        }
        catch (IOException e) {
            LOG.error((Object)("createCandidateStamp: Failed (maybe previous task failed) to create filestamp " + myCandidacyPath), (Throwable)e);
        }
    }

    private static void createNewFileWithRetries(FileSystem fs, Path path, int maxAttempts, int retryWaitMsecs) {
        int attempt;
        for (attempt = 0; attempt < maxAttempts; ++attempt) {
            try {
                fs.createNewFile(path);
                return;
            }
            catch (IOException e) {
                LOG.warn((Object)("createNewFileWithRetries: Failed to create file at path " + path + " on attempt " + attempt + " of " + maxAttempts + "."), (Throwable)e);
                Uninterruptibles.sleepUninterruptibly((long)retryWaitMsecs, (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
        }
        throw new IllegalStateException("createNewFileWithRetries: Failed to create file at path " + path + " after " + attempt + " attempts");
    }

    private void createZooKeeperClosedStamp() {
        LOG.info((Object)("createZooKeeperClosedStamp: Creating my filestamp " + this.myClosedPath));
        ZooKeeperManager.createNewFileWithRetries(this.fs, this.myClosedPath, this.conf.getHdfsFileCreationRetries(), this.conf.getHdfsFileCreationRetryWaitMs());
    }

    public boolean computationDone() {
        try {
            return this.fs.exists(this.myClosedPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createZooKeeperServerList() throws IOException, InterruptedException {
        int candidateRetrievalAttempt = 0;
        TreeMap hostnameTaskMap = Maps.newTreeMap();
        while (true) {
            FileStatus[] fileStatusArray = this.fs.listStatus(this.taskDirectory);
            hostnameTaskMap.clear();
            if (fileStatusArray.length <= 0) continue;
            for (FileStatus fileStatus : fileStatusArray) {
                String[] hostnameTaskArray = fileStatus.getPath().getName().split(HOSTNAME_TASK_SEPARATOR);
                if (hostnameTaskArray.length != 2) {
                    throw new RuntimeException("getZooKeeperServerList: Task 0 failed to parse " + fileStatus.getPath().getName());
                }
                if (hostnameTaskMap.containsKey(hostnameTaskArray[0])) continue;
                hostnameTaskMap.put(hostnameTaskArray[0], new Integer(hostnameTaskArray[1]));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("getZooKeeperServerList: Got " + hostnameTaskMap.keySet() + HOSTNAME_TASK_SEPARATOR + hostnameTaskMap.size() + " hosts from " + fileStatusArray.length + " candidates when " + this.serverCount + " required (polling period is " + this.pollMsecs + ") on attempt " + candidateRetrievalAttempt));
            }
            if (hostnameTaskMap.size() >= this.serverCount) break;
            ++candidateRetrievalAttempt;
            Thread.sleep(this.pollMsecs);
        }
        StringBuffer serverListFile = new StringBuffer(ZOOKEEPER_SERVER_LIST_FILE_PREFIX);
        int numServers = 0;
        for (Map.Entry hostnameTask : hostnameTaskMap.entrySet()) {
            serverListFile.append((String)hostnameTask.getKey() + HOSTNAME_TASK_SEPARATOR + hostnameTask.getValue() + HOSTNAME_TASK_SEPARATOR);
            if (++numServers != this.serverCount) continue;
            break;
        }
        Path serverListPath = new Path(this.baseDirectory, serverListFile.toString());
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("createZooKeeperServerList: Creating the final ZooKeeper file '" + serverListPath + "'"));
        }
        this.fs.createNewFile(serverListPath);
    }

    private String getServerListFile() throws IOException {
        FileStatus[] fileStatusArray;
        String serverListFile = null;
        for (FileStatus fileStatus : fileStatusArray = this.fs.listStatus(this.baseDirectory)) {
            if (!fileStatus.getPath().getName().startsWith(ZOOKEEPER_SERVER_LIST_FILE_PREFIX)) continue;
            serverListFile = fileStatus.getPath().getName();
            break;
        }
        return serverListFile;
    }

    private void getZooKeeperServerList() throws IOException, InterruptedException {
        String serverListFile;
        if (this.taskPartition == 0 && (serverListFile = this.getServerListFile()) == null) {
            this.createZooKeeperServerList();
        }
        while (true) {
            serverListFile = this.getServerListFile();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("getZooKeeperServerList: For task " + this.taskPartition + ", got file '" + serverListFile + "' (polling period is " + this.pollMsecs + ")"));
            }
            if (serverListFile != null) break;
            try {
                Thread.sleep(this.pollMsecs);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("getZooKeeperServerList: Strange interrupted exception " + e.getMessage()));
            }
        }
        List<String> serverHostList = Arrays.asList(serverListFile.substring(ZOOKEEPER_SERVER_LIST_FILE_PREFIX.length()).split(HOSTNAME_TASK_SEPARATOR));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("getZooKeeperServerList: Found " + serverHostList + HOSTNAME_TASK_SEPARATOR + serverHostList.size() + " hosts in filename '" + serverListFile + "'"));
        }
        if (serverHostList.size() != this.serverCount * 2) {
            throw new IllegalStateException("getZooKeeperServerList: Impossible  that " + serverHostList.size() + " != 2 * " + this.serverCount + " asked for.");
        }
        for (int i = 0; i < serverHostList.size(); i += 2) {
            this.zkServerPortMap.put(serverHostList.get(i), Integer.parseInt(serverHostList.get(i + 1)));
        }
        this.zkServerPortString = "";
        for (String server : this.zkServerPortMap.keySet()) {
            if (this.zkServerPortString.length() > 0) {
                this.zkServerPortString = this.zkServerPortString + ",";
            }
            this.zkServerPortString = this.zkServerPortString + server + ":" + this.zkBasePort;
        }
    }

    public String getZooKeeperServerPortString() {
        return this.zkServerPortString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateZooKeeperConfigFile(List<String> serverList) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("generateZooKeeperConfigFile: Creating file " + this.configFilePath + " in " + this.zkDir + " with base port " + this.zkBasePort));
        }
        try {
            FileWriter writer;
            block12: {
                File zkDirFile = new File(this.zkDir);
                boolean mkDirRet = zkDirFile.mkdirs();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("generateZooKeeperConfigFile: Make directory of " + zkDirFile.getName() + " = " + mkDirRet));
                }
                File configFile = new File(this.configFilePath);
                boolean deletedRet = configFile.delete();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("generateZooKeeperConfigFile: Delete of " + configFile.getName() + " = " + deletedRet));
                }
                if (!configFile.createNewFile()) {
                    throw new IllegalStateException("generateZooKeeperConfigFile: Failed to create config file " + configFile.getName());
                }
                if (!configFile.setWritable(true, false)) {
                    throw new IllegalStateException("generateZooKeeperConfigFile: Failed to make writable " + configFile.getName());
                }
                writer = null;
                try {
                    writer = new FileWriter(this.configFilePath);
                    writer.write("tickTime=6000\n");
                    writer.write("dataDir=" + this.zkDir + "\n");
                    writer.write("clientPort=" + this.zkBasePort + "\n");
                    writer.write("maxClientCnxns=10000\n");
                    writer.write("minSessionTimeout=" + this.conf.getZooKeeperMinSessionTimeout() + "\n");
                    writer.write("maxSessionTimeout=" + this.conf.getZooKeeperMaxSessionTimeout() + "\n");
                    writer.write("initLimit=10\n");
                    writer.write("syncLimit=5\n");
                    writer.write("snapCount=50000\n");
                    writer.write("forceSync=" + (this.conf.getZooKeeperForceSync() ? "yes" : "no") + "\n");
                    writer.write("skipACL=" + (this.conf.getZooKeeperSkipAcl() ? "yes" : "no") + "\n");
                    if (serverList.size() == 1) break block12;
                    writer.write("electionAlg=0\n");
                    for (int i = 0; i < serverList.size(); ++i) {
                        writer.write("server." + i + "=" + serverList.get(i) + ":" + (this.zkBasePort + 1) + ":" + (this.zkBasePort + 2) + "\n");
                        if (!this.myHostname.equals(serverList.get(i))) continue;
                        FileWriter myidWriter = null;
                        try {
                            myidWriter = new FileWriter(this.zkDir + "/myid");
                            myidWriter.write(i + "\n");
                        }
                        catch (Throwable throwable) {
                            Closeables.close(myidWriter, (boolean)true);
                            throw throwable;
                        }
                        Closeables.close((Closeable)myidWriter, (boolean)true);
                    }
                }
                catch (Throwable throwable) {
                    Closeables.close(writer, (boolean)true);
                    throw throwable;
                }
            }
            Closeables.close((Closeable)writer, (boolean)true);
        }
        catch (IOException e) {
            throw new IllegalStateException("generateZooKeeperConfigFile: Failed to write file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onlineZooKeeperServers() {
        Integer taskId = this.zkServerPortMap.get(this.myHostname);
        if (taskId != null && taskId == this.taskPartition) {
            File zkDirFile = new File(this.zkDir);
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("onlineZooKeeperServers: Trying to delete old directory " + this.zkDir));
                }
                FileUtils.deleteDirectory((File)zkDirFile);
            }
            catch (IOException e) {
                LOG.warn((Object)("onlineZooKeeperServers: Failed to delete directory " + this.zkDir), (Throwable)e);
            }
            this.generateZooKeeperConfigFile(new ArrayList<String>(this.zkServerPortMap.keySet()));
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            ArrayList commandList = Lists.newArrayList();
            String javaHome = System.getProperty("java.home");
            if (javaHome == null) {
                throw new IllegalArgumentException("onlineZooKeeperServers: java.home is not set!");
            }
            commandList.add(javaHome + "/bin/java");
            commandList.add("-cp");
            commandList.add(System.getProperty("java.class.path"));
            String zkJavaOptsString = GiraphConstants.ZOOKEEPER_JAVA_OPTS.get(this.conf);
            String[] zkJavaOptsArray = zkJavaOptsString.split(HOSTNAME_TASK_SEPARATOR);
            if (zkJavaOptsArray != null) {
                commandList.addAll(Arrays.asList(zkJavaOptsArray));
            }
            commandList.add(QuorumPeerMain.class.getName());
            commandList.add(this.configFilePath);
            processBuilder.command(commandList);
            File execDirectory = new File(this.zkDir);
            processBuilder.directory(execDirectory);
            processBuilder.redirectErrorStream(true);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("onlineZooKeeperServers: Attempting to start ZooKeeper server with command " + commandList + " in directory " + execDirectory.toString()));
            }
            try {
                ZooKeeperManager zooKeeperManager = this;
                synchronized (zooKeeperManager) {
                    this.zkProcess = processBuilder.start();
                    this.zkProcessCollector = new StreamCollector(this.zkProcess.getInputStream());
                    this.zkProcessCollector.start();
                }
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LOG.info((Object)"run: Shutdown hook started.");
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (ZooKeeperManager.this.zkProcess != null) {
                                LOG.warn((Object)"onlineZooKeeperServers: Forced a shutdown hook kill of the ZooKeeper process.");
                                ZooKeeperManager.this.zkProcess.destroy();
                                int exitCode = -1;
                                try {
                                    exitCode = ZooKeeperManager.this.zkProcess.waitFor();
                                }
                                catch (InterruptedException e) {
                                    LOG.warn((Object)"run: Couldn't get exit code.");
                                }
                                LOG.info((Object)("onlineZooKeeperServers: ZooKeeper process exited with " + exitCode + " (note that 143 " + "typically means killed)."));
                            }
                        }
                    }
                };
                Runtime.getRuntime().addShutdownHook(new Thread(runnable));
                LOG.info((Object)"onlineZooKeeperServers: Shutdown hook added.");
            }
            catch (IOException e) {
                LOG.error((Object)"onlineZooKeeperServers: Failed to start ZooKeeper process", (Throwable)e);
                throw new RuntimeException(e);
            }
            int connectAttempts = 0;
            int maxConnectAttempts = this.conf.getZookeeperConnectionAttempts();
            while (connectAttempts < maxConnectAttempts) {
                try {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("onlineZooKeeperServers: Connect attempt " + connectAttempts + " of " + maxConnectAttempts + " max trying to connect to " + this.myHostname + ":" + this.zkBasePort + " with poll msecs = " + this.pollMsecs));
                    }
                    InetSocketAddress zkServerAddress = new InetSocketAddress(this.myHostname, this.zkBasePort);
                    Socket testServerSock = new Socket();
                    testServerSock.connect(zkServerAddress, 5000);
                    if (!LOG.isInfoEnabled()) break;
                    LOG.info((Object)("onlineZooKeeperServers: Connected to " + zkServerAddress + "!"));
                    break;
                }
                catch (SocketTimeoutException e) {
                    LOG.warn((Object)"onlineZooKeeperServers: Got SocketTimeoutException", (Throwable)e);
                }
                catch (ConnectException e) {
                    LOG.warn((Object)"onlineZooKeeperServers: Got ConnectException", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.warn((Object)"onlineZooKeeperServers: Got IOException", (Throwable)e);
                }
                ++connectAttempts;
                try {
                    Thread.sleep(this.pollMsecs);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)("onlineZooKeeperServers: Sleep of " + this.pollMsecs + " interrupted - " + e.getMessage()));
                }
            }
            if (connectAttempts == maxConnectAttempts) {
                throw new IllegalStateException("onlineZooKeeperServers: Failed to connect in " + connectAttempts + " tries!");
            }
            Path myReadyPath = new Path(this.serverDirectory, this.myHostname + HOSTNAME_TASK_SEPARATOR + this.taskPartition);
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("onlineZooKeeperServers: Creating my filestamp " + myReadyPath));
                }
                this.fs.createNewFile(myReadyPath);
            }
            catch (IOException e) {
                LOG.error((Object)("onlineZooKeeperServers: Failed (maybe previous task failed) to create filestamp " + myReadyPath), (Throwable)e);
            }
        } else {
            ArrayList<String> foundList = new ArrayList<String>();
            int readyRetrievalAttempt = 0;
            block19: while (true) {
                try {
                    while (true) {
                        FileStatus[] fileStatusArray = this.fs.listStatus(this.serverDirectory);
                        foundList.clear();
                        if (fileStatusArray != null && fileStatusArray.length > 0) {
                            for (int i = 0; i < fileStatusArray.length; ++i) {
                                String[] hostnameTaskArray = fileStatusArray[i].getPath().getName().split(HOSTNAME_TASK_SEPARATOR);
                                if (hostnameTaskArray.length != 2) {
                                    throw new RuntimeException("getZooKeeperServerList: Task 0 failed to parse " + fileStatusArray[i].getPath().getName());
                                }
                                foundList.add(hostnameTaskArray[0]);
                            }
                            if (LOG.isInfoEnabled()) {
                                LOG.info((Object)("onlineZooKeeperServers: Got " + foundList + HOSTNAME_TASK_SEPARATOR + foundList.size() + " hosts from " + fileStatusArray.length + " ready servers when " + this.serverCount + " required (polling period is " + this.pollMsecs + ") on attempt " + readyRetrievalAttempt));
                            }
                            if (foundList.containsAll(this.zkServerPortMap.keySet())) {
                                break block19;
                            }
                        } else if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("onlineZooKeeperSErvers: Empty directory " + this.serverDirectory + ", waiting " + this.pollMsecs + " msecs."));
                        }
                        Thread.sleep(this.pollMsecs);
                        ++readyRetrievalAttempt;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)("onlineZooKeeperServers: Strange interrupt from " + e.getMessage()), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private void waitUntilAllTasksDone(int totalWorkers) {
        block9: {
            int attempt = 0;
            long maxMs = this.time.getMilliseconds() + (long)this.conf.getWaitTaskDoneTimeoutMs();
            do {
                boolean[] taskDoneArray = new boolean[totalWorkers];
                try {
                    FileStatus[] fileStatusArray = this.fs.listStatus(this.taskDirectory);
                    int totalDone = 0;
                    if (fileStatusArray.length > 0) {
                        for (FileStatus fileStatus : fileStatusArray) {
                            String name = fileStatus.getPath().getName();
                            if (!ComputationDoneName.isName(name)) continue;
                            ++totalDone;
                            taskDoneArray[ComputationDoneName.fromName((String)name).getWorkerId()] = true;
                        }
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("waitUntilAllTasksDone: Got " + totalDone + " and " + totalWorkers + " desired (polling period is " + this.pollMsecs + ") on attempt " + attempt));
                    }
                    if (totalDone < totalWorkers) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < taskDoneArray.length; ++i) {
                            if (taskDoneArray[i]) continue;
                            sb.append(i).append(", ");
                        }
                        LOG.info((Object)("waitUntilAllTasksDone: Still waiting on tasks " + sb.toString()));
                        ++attempt;
                        Thread.sleep(this.pollMsecs);
                        this.context.progress();
                        continue;
                    }
                    break block9;
                }
                catch (IOException e) {
                    LOG.warn((Object)"waitUntilAllTasksDone: Got IOException.", (Throwable)e);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"waitUntilAllTasksDone: Got InterruptedException", (Throwable)e);
                }
            } while (this.time.getMilliseconds() <= maxMs);
            throw new IllegalStateException("waitUntilAllTasksDone: Tasks did not finish by the maximum time of " + this.conf.getWaitTaskDoneTimeoutMs() + " milliseconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offlineZooKeeperServers(State state) {
        if (state == State.FINISHED) {
            this.createZooKeeperClosedStamp();
        }
        ZooKeeperManager zooKeeperManager = this;
        synchronized (zooKeeperManager) {
            if (this.zkProcess != null) {
                boolean isYarnJob = GiraphConstants.IS_PURE_YARN_JOB.get(this.conf);
                int totalWorkers = this.conf.getMapTasks();
                if (isYarnJob) {
                    totalWorkers = this.conf.getInt("giraph.maxWorkers", 0) + 1;
                }
                LOG.info((Object)("offlineZooKeeperServers: Will wait for " + totalWorkers + " tasks"));
                this.waitUntilAllTasksDone(totalWorkers);
                this.zkProcess.destroy();
                int exitValue = -1;
                try {
                    this.zkProcessCollector.join();
                    exitValue = this.zkProcess.waitFor();
                    File zkDirFile = new File(this.zkDir);
                    FileUtils.deleteDirectory((File)zkDirFile);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"offlineZooKeeperServers: InterruptedException, but continuing ", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.warn((Object)"offlineZooKeeperSevers: IOException, but continuing", (Throwable)e);
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("offlineZooKeeperServers: waitFor returned " + exitValue + " and deleted directory " + this.zkDir));
                }
                this.zkProcess = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runsZooKeeper() {
        ZooKeeperManager zooKeeperManager = this;
        synchronized (zooKeeperManager) {
            return this.zkProcess != null;
        }
    }

    public void logZooKeeperOutput(Level level) {
        if (this.zkProcessCollector != null) {
            LOG.log((Priority)level, (Object)"logZooKeeperOutput: Dumping up to last 100 lines of the ZooKeeper process STDOUT and STDERR.");
            this.zkProcessCollector.dumpLastLines(level);
        }
    }

    private static class StreamCollector
    extends Thread {
        private static final int LAST_LINES_COUNT = 100;
        private static final Logger LOG = Logger.getLogger(StreamCollector.class);
        private final BufferedReader bufferedReader;
        private final LinkedList<String> lastLines = Lists.newLinkedList();

        public StreamCollector(InputStream is) {
            super(StreamCollector.class.getName());
            this.setDaemon(true);
            InputStreamReader streamReader = new InputStreamReader(is, Charset.defaultCharset());
            this.bufferedReader = new BufferedReader(streamReader);
        }

        @Override
        public void run() {
            this.readLines();
        }

        private synchronized void readLines() {
            try {
                String line;
                while ((line = this.bufferedReader.readLine()) != null) {
                    if (this.lastLines.size() > 100) {
                        this.lastLines.removeFirst();
                    }
                    this.lastLines.add(line);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("readLines: " + line));
                }
            }
            catch (IOException e) {
                LOG.error((Object)"readLines: Ignoring IOException", (Throwable)e);
            }
        }

        public synchronized void dumpLastLines(Level level) {
            this.readLines();
            for (String line : this.lastLines) {
                LOG.log((Priority)level, (Object)line);
            }
        }
    }

    public static enum State {
        FAILED,
        FINISHED;

    }
}

