/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.zk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZooKeeperExt {
    private static final Logger LOG = Logger.getLogger(ZooKeeperExt.class);
    private static final int SEQUENCE_NUMBER_LENGTH = 10;
    private final ZooKeeper zooKeeper;
    private final Progressable progressable;
    private final int maxRetryAttempts;
    private final int retryWaitMsecs;

    public ZooKeeperExt(String connectString, int sessionTimeout, int maxRetryAttempts, int retryWaitMsecs, Watcher watcher) throws IOException {
        this(connectString, sessionTimeout, maxRetryAttempts, retryWaitMsecs, watcher, null);
    }

    public ZooKeeperExt(String connectString, int sessionTimeout, int maxRetryAttempts, int retryWaitMsecs, Watcher watcher, Progressable progressable) throws IOException {
        this.zooKeeper = new ZooKeeper(connectString, sessionTimeout, watcher);
        this.progressable = progressable;
        this.maxRetryAttempts = maxRetryAttempts;
        this.retryWaitMsecs = retryWaitMsecs;
    }

    public String createExt(String path, byte[] data, List<ACL> acl, CreateMode createMode, boolean recursive) throws KeeperException, InterruptedException {
        int attempt;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createExt: Creating path " + path));
        }
        for (attempt = 0; attempt < this.maxRetryAttempts; ++attempt) {
            try {
                if (!recursive) {
                    return this.zooKeeper.create(path, data, acl, createMode);
                }
                try {
                    return this.zooKeeper.create(path, data, acl, createMode);
                }
                catch (KeeperException.NoNodeException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("createExt: Cannot directly create node " + path));
                    }
                    int pos = path.indexOf("/", 1);
                    while (pos != -1) {
                        block12: {
                            try {
                                if (this.progressable != null) {
                                    this.progressable.progress();
                                }
                                this.zooKeeper.create(path.substring(0, pos), null, acl, CreateMode.PERSISTENT);
                            }
                            catch (KeeperException.NodeExistsException e2) {
                                if (!LOG.isDebugEnabled()) break block12;
                                LOG.debug((Object)("createExt: Znode " + path.substring(0, pos) + " already exists"));
                            }
                        }
                        pos = path.indexOf("/", pos + 1);
                    }
                    return this.zooKeeper.create(path, data, acl, createMode);
                }
            }
            catch (KeeperException.ConnectionLossException e) {
                LOG.warn((Object)("createExt: Connection loss on attempt " + attempt + ", " + "waiting " + this.retryWaitMsecs + " msecs before retrying."), (Throwable)e);
                Thread.sleep(this.retryWaitMsecs);
                continue;
            }
        }
        throw new IllegalStateException("createExt: Failed to create " + path + " after " + attempt + " tries!");
    }

    public PathStat createOrSetExt(String path, byte[] data, List<ACL> acl, CreateMode createMode, boolean recursive, int version) throws KeeperException, InterruptedException {
        String createdPath = null;
        Stat setStat = null;
        try {
            createdPath = this.createExt(path, data, acl, createMode, recursive);
        }
        catch (KeeperException.NodeExistsException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("createOrSet: Node exists on path " + path));
            }
            setStat = this.zooKeeper.setData(path, data, version);
        }
        return new PathStat(createdPath, setStat);
    }

    public PathStat createOnceExt(String path, byte[] data, List<ACL> acl, CreateMode createMode, boolean recursive) throws KeeperException, InterruptedException {
        Stat setStat;
        String createdPath;
        block2: {
            createdPath = null;
            setStat = null;
            try {
                createdPath = this.createExt(path, data, acl, createMode, recursive);
            }
            catch (KeeperException.NodeExistsException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)("createOnceExt: Node already exists on path " + path));
            }
        }
        return new PathStat(createdPath, setStat);
    }

    public void deleteExt(String path, int version, boolean recursive) throws InterruptedException, KeeperException {
        int attempt;
        for (attempt = 0; attempt < this.maxRetryAttempts; ++attempt) {
            try {
                if (!recursive) {
                    this.zooKeeper.delete(path, version);
                    return;
                }
                try {
                    this.zooKeeper.delete(path, version);
                    return;
                }
                catch (KeeperException.NotEmptyException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("deleteExt: Cannot directly remove node " + path));
                    }
                    List childList = this.zooKeeper.getChildren(path, false);
                    for (String child : childList) {
                        if (this.progressable != null) {
                            this.progressable.progress();
                        }
                        this.deleteExt(path + "/" + child, -1, true);
                    }
                    this.zooKeeper.delete(path, version);
                    return;
                }
            }
            catch (KeeperException.ConnectionLossException e) {
                LOG.warn((Object)("deleteExt: Connection loss on attempt " + attempt + ", waiting " + this.retryWaitMsecs + " msecs before retrying."), (Throwable)e);
                Thread.sleep(this.retryWaitMsecs);
                continue;
            }
        }
        throw new IllegalStateException("deleteExt: Failed to delete " + path + " after " + attempt + " tries!");
    }

    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        int attempt;
        for (attempt = 0; attempt < this.maxRetryAttempts; ++attempt) {
            try {
                return this.zooKeeper.exists(path, watch);
            }
            catch (KeeperException.ConnectionLossException e) {
                LOG.warn((Object)("exists: Connection loss on attempt " + attempt + ", waiting " + this.retryWaitMsecs + " msecs before retrying."), (Throwable)e);
                Thread.sleep(this.retryWaitMsecs);
                continue;
            }
        }
        throw new IllegalStateException("exists: Failed to check " + path + " after " + attempt + " tries!");
    }

    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        int attempt;
        for (attempt = 0; attempt < this.maxRetryAttempts; ++attempt) {
            try {
                return this.zooKeeper.exists(path, watcher);
            }
            catch (KeeperException.ConnectionLossException e) {
                LOG.warn((Object)("exists: Connection loss on attempt " + attempt + ", waiting " + this.retryWaitMsecs + " msecs before retrying."), (Throwable)e);
                Thread.sleep(this.retryWaitMsecs);
                continue;
            }
        }
        throw new IllegalStateException("exists: Failed to check " + path + " after " + attempt + " tries!");
    }

    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        int attempt;
        for (attempt = 0; attempt < this.maxRetryAttempts; ++attempt) {
            try {
                return this.zooKeeper.getData(path, watcher, stat);
            }
            catch (KeeperException.ConnectionLossException e) {
                LOG.warn((Object)("getData: Connection loss on attempt " + attempt + ", waiting " + this.retryWaitMsecs + " msecs before retrying."), (Throwable)e);
                Thread.sleep(this.retryWaitMsecs);
                continue;
            }
        }
        throw new IllegalStateException("getData: Failed to get " + path + " after " + attempt + " tries!");
    }

    public byte[] getData(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        int attempt;
        for (attempt = 0; attempt < this.maxRetryAttempts; ++attempt) {
            try {
                return this.zooKeeper.getData(path, watch, stat);
            }
            catch (KeeperException.ConnectionLossException e) {
                LOG.warn((Object)("getData: Connection loss on attempt " + attempt + ", waiting " + this.retryWaitMsecs + " msecs before retrying."), (Throwable)e);
                Thread.sleep(this.retryWaitMsecs);
                continue;
            }
        }
        throw new IllegalStateException("getData: Failed to get " + path + " after " + attempt + " tries!");
    }

    public List<String> getChildrenExt(String path, boolean watch, boolean sequenceSorted, boolean fullPath) throws KeeperException, InterruptedException {
        int attempt;
        for (attempt = 0; attempt < this.maxRetryAttempts; ++attempt) {
            try {
                List childList = this.zooKeeper.getChildren(path, watch);
                if (sequenceSorted) {
                    Collections.sort(childList, new Comparator<String>(){

                        @Override
                        public int compare(String s1, String s2) {
                            if (s1.length() <= 10 || s2.length() <= 10) {
                                throw new RuntimeException("getChildrenExt: Invalid length for sequence  sorting > 10 for s1 (" + s1.length() + ") or s2 (" + s2.length() + ")");
                            }
                            int s1sequenceNumber = Integer.parseInt(s1.substring(s1.length() - 10));
                            int s2sequenceNumber = Integer.parseInt(s2.substring(s2.length() - 10));
                            return s1sequenceNumber - s2sequenceNumber;
                        }
                    });
                }
                if (fullPath) {
                    ArrayList<String> fullChildList = new ArrayList<String>();
                    for (String child : childList) {
                        fullChildList.add(path + "/" + child);
                    }
                    return fullChildList;
                }
                return childList;
            }
            catch (KeeperException.ConnectionLossException e) {
                LOG.warn((Object)("getChildrenExt: Connection loss on attempt " + attempt + ", waiting " + this.retryWaitMsecs + " msecs before retrying."), (Throwable)e);
                Thread.sleep(this.retryWaitMsecs);
                continue;
            }
        }
        throw new IllegalStateException("createExt: Failed to create " + path + " after " + attempt + " tries!");
    }

    public void close() throws InterruptedException {
        this.zooKeeper.close();
    }

    public static class PathStat {
        private String path;
        private Stat stat;

        public PathStat(String path, Stat stat) {
            this.path = path;
            this.stat = stat;
        }

        public String getPath() {
            return this.path;
        }

        public Stat getStat() {
            return this.stat;
        }
    }
}

