/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.zk;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.giraph.time.SystemTime;
import org.apache.giraph.time.Time;
import org.apache.giraph.zk.BspEvent;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class PredicateLock
implements BspEvent {
    private static final Logger LOG = Logger.getLogger(PredicateLock.class);
    private static final int DEFAULT_MSEC_PERIOD = 10000;
    protected final Progressable progressable;
    private final int msecPeriod;
    private Lock lock = new ReentrantLock();
    private Condition cond = this.lock.newCondition();
    private boolean eventOccurred = false;
    private final Time time;

    public PredicateLock(Progressable progressable) {
        this(progressable, 10000, SystemTime.get());
    }

    public PredicateLock(Progressable progressable, int msecPeriod, Time time) {
        this.progressable = progressable;
        this.msecPeriod = msecPeriod;
        this.time = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.lock.lock();
        try {
            this.eventOccurred = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signal() {
        this.lock.lock();
        try {
            this.eventOccurred = true;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitMsecs(int msecs) {
        if (msecs < 0) {
            throw new RuntimeException("waitMsecs: msecs cannot be negative!");
        }
        long maxMsecs = this.time.getMilliseconds() + (long)msecs;
        int curMsecTimeout = 0;
        this.lock.lock();
        try {
            while (!this.eventOccurred) {
                curMsecTimeout = Math.min(msecs, this.msecPeriod);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("waitMsecs: Wait for " + curMsecTimeout));
                }
                try {
                    boolean signaled = this.cond.await(curMsecTimeout, TimeUnit.MILLISECONDS);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("waitMsecs: Got timed signaled of " + signaled));
                    }
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("waitMsecs: Caught interrupted exception on cond.await() " + curMsecTimeout, e);
                }
                if (this.time.getMilliseconds() > maxMsecs) {
                    boolean bl = false;
                    return bl;
                }
                msecs = Math.max(0, msecs - curMsecTimeout);
                this.progressable.progress();
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    @Override
    public void waitForever() {
        while (!this.waitMsecs(this.msecPeriod)) {
            this.progressable.progress();
        }
    }
}

