/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.zk;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class GiraphZooKeeperAdmin
implements Watcher,
Tool {
    private Configuration conf;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public int run(String[] args) {
        GiraphConfiguration giraphConf = new GiraphConfiguration(this.getConf());
        int zkPort = GiraphConstants.ZOOKEEPER_SERVER_PORT.get(giraphConf);
        String zkBasePath = giraphConf.get("giraph.zkBaseZNode", "") + "/_hadoopBsp";
        String zkServerListStr = giraphConf.getZookeeperList();
        if (zkServerListStr.isEmpty()) {
            throw new IllegalStateException("GiraphZooKeeperAdmin requires a list of ZooKeeper servers to clean.");
        }
        Object[] zkServerList = zkServerListStr.split(",");
        System.out.println("[GIRAPH-ZKADMIN] Attempting to clean Zookeeper hosts at: " + Arrays.deepToString(zkServerList));
        System.out.println("[GIRAPH-ZKADMIN] Connecting on port: " + zkPort);
        System.out.println("[GIRAPH-ZKADMIN] to ZNode root path: " + zkBasePath);
        try {
            ZooKeeperExt zooKeeper = new ZooKeeperExt(this.formatZkServerList((String[])zkServerList, zkPort), GiraphConstants.ZOOKEEPER_SESSION_TIMEOUT.getDefaultValue(), GiraphConstants.ZOOKEEPER_OPS_MAX_ATTEMPTS.getDefaultValue(), GiraphConstants.ZOOKEEPER_SERVERLIST_POLL_MSECS.getDefaultValue(), this);
            this.doZooKeeperCleanup(zooKeeper, zkBasePath);
            return 0;
        }
        catch (KeeperException e) {
            System.err.println("[ERROR] Failed to do cleanup of " + zkBasePath + " due to KeeperException: " + e.getMessage());
        }
        catch (InterruptedException e) {
            System.err.println("[ERROR] Failed to do cleanup of " + zkBasePath + " due to InterruptedException: " + e.getMessage());
        }
        catch (UnknownHostException e) {
            System.err.println("[ERROR] Failed to do cleanup of " + zkBasePath + " due to UnknownHostException: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("[ERROR] Failed to do cleanup of " + zkBasePath + " due to IOException: " + e.getMessage());
        }
        return -1;
    }

    public final void process(WatchedEvent event) {
        System.out.println("[GIRAPH-ZKADMIN] ZK event received: " + event);
    }

    public void doZooKeeperCleanup(ZooKeeperExt zooKeeper, String zkBasePath) throws KeeperException, InterruptedException {
        try {
            zooKeeper.deleteExt(zkBasePath, -1, false);
            System.out.println("[GIRAPH-ZKADMIN] Deleted: " + zkBasePath);
        }
        catch (KeeperException.NotEmptyException e) {
            List<String> childList = zooKeeper.getChildrenExt(zkBasePath, false, false, false);
            for (String child : childList) {
                String childPath = zkBasePath + "/" + child;
                this.doZooKeeperCleanup(zooKeeper, childPath);
            }
            zooKeeper.deleteExt(zkBasePath, -1, false);
            System.out.println("[GIRAPH-ZKADMIN] Deleted: " + zkBasePath);
        }
    }

    private String formatZkServerList(String[] zkServerList, int zkPort) throws UnknownHostException {
        StringBuffer zkConnectList = new StringBuffer();
        for (String zkServer : zkServerList) {
            if (zkServer.equals("")) continue;
            zkConnectList.append(zkServer + ":" + zkPort + ",");
        }
        return zkConnectList.substring(0, zkConnectList.length() - 1);
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new GiraphZooKeeperAdmin(), (String[])args));
    }

    static {
        Configuration.addDefaultResource((String)"giraph-site.xml");
    }
}

