/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.zk;

import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ComputationDoneName {
    private static final String COMPUTATION_DONE_SUFFIX = ".COMPUTATION_DONE";
    private final int workerId;
    private final String name;

    public ComputationDoneName(int workerId) {
        this.workerId = workerId;
        this.name = Integer.toString(workerId) + COMPUTATION_DONE_SUFFIX;
    }

    public int getWorkerId() {
        return this.workerId;
    }

    public String getName() {
        return this.name;
    }

    public static final ComputationDoneName fromName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkArgument((boolean)name.endsWith(COMPUTATION_DONE_SUFFIX), (String)"Name %s is not a valid ComputationDoneName", (Object[])new Object[]{name});
        return new ComputationDoneName(Integer.parseInt(name.replace(COMPUTATION_DONE_SUFFIX, "")));
    }

    public static final boolean isName(String name) {
        return name.endsWith(COMPUTATION_DONE_SUFFIX);
    }
}

