/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.worker;

import org.apache.giraph.job.JobProgressTracker;
import org.apache.giraph.worker.WorkerProgress;
import org.apache.log4j.Logger;

public class WorkerProgressWriter {
    private static final Logger LOG = Logger.getLogger(WorkerProgressWriter.class);
    private static final int WRITE_UPDATE_PERIOD_MILLISECONDS = 10000;
    private final JobProgressTracker jobProgressTracker;
    private final Thread writerThread;
    private volatile boolean finished = false;

    public WorkerProgressWriter(JobProgressTracker jobProgressTracker) {
        this.jobProgressTracker = jobProgressTracker;
        this.writerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        while (!WorkerProgressWriter.this.finished) {
                            WorkerProgressWriter.this.updateAndSendProgress();
                            double factor = 1.0 + Math.random();
                            Thread.sleep((long)(10000.0 * factor));
                        }
                    }
                    catch (InterruptedException e) {
                        if (!LOG.isInfoEnabled()) break block3;
                        LOG.info((Object)"run: WorkerProgressWriter interrupted");
                    }
                }
            }
        });
        this.writerThread.start();
    }

    private void updateAndSendProgress() {
        WorkerProgress.get().updateMemory();
        this.jobProgressTracker.updateProgress(WorkerProgress.get());
    }

    public void stop() throws InterruptedException {
        this.finished = true;
        this.writerThread.interrupt();
        this.writerThread.join();
        this.updateAndSendProgress();
    }
}

