/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.worker;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.giraph.utils.MemoryUtils;

@ThriftStruct
@ThreadSafe
public class WorkerProgress {
    private static final WorkerProgress INSTANCE = new WorkerProgress();
    protected long currentSuperstep = -1L;
    protected long verticesLoaded = 0L;
    protected int vertexInputSplitsLoaded = 0;
    protected boolean loadingVerticesDone = false;
    protected long edgesLoaded = 0L;
    protected int edgeInputSplitsLoaded = 0;
    protected boolean loadingEdgesDone = false;
    protected long verticesToCompute = 0L;
    protected long verticesComputed = 0L;
    protected int partitionsToCompute = 0;
    protected int partitionsComputed = 0;
    protected boolean computationDone = false;
    protected long verticesToStore = 0L;
    protected long verticesStored = 0L;
    protected int partitionsToStore = 0;
    protected int partitionsStored = 0;
    protected boolean storingDone = false;
    protected int taskId;
    protected double freeMemoryMB;

    public static WorkerProgress get() {
        return INSTANCE;
    }

    public synchronized void addVerticesLoaded(long verticesLoaded) {
        this.verticesLoaded += verticesLoaded;
    }

    public synchronized void incrementVertexInputSplitsLoaded() {
        ++this.vertexInputSplitsLoaded;
    }

    public synchronized void finishLoadingVertices() {
        this.loadingVerticesDone = true;
    }

    public synchronized void addEdgesLoaded(long edgesLoaded) {
        this.edgesLoaded += edgesLoaded;
    }

    public synchronized void incrementEdgeInputSplitsLoaded() {
        ++this.edgeInputSplitsLoaded;
    }

    public synchronized void finishLoadingEdges() {
        this.loadingEdgesDone = true;
    }

    public synchronized void startSuperstep(long superstep, long verticesToCompute, int partitionsToCompute) {
        this.currentSuperstep = superstep;
        this.verticesToCompute = verticesToCompute;
        this.partitionsToCompute = partitionsToCompute;
        this.verticesComputed = 0L;
        this.partitionsComputed = 0;
    }

    public synchronized void addVerticesComputed(long verticesComputed) {
        this.verticesComputed += verticesComputed;
    }

    public synchronized void incrementPartitionsComputed() {
        ++this.partitionsComputed;
    }

    public synchronized void startStoring(long verticesToStore, int partitionsToStore) {
        this.computationDone = true;
        this.verticesToCompute = 0L;
        this.verticesComputed = 0L;
        this.partitionsToCompute = 0;
        this.partitionsComputed = 0;
        this.currentSuperstep = Long.MAX_VALUE;
        this.verticesToStore = verticesToStore;
        this.partitionsToStore = partitionsToStore;
    }

    public synchronized void addVerticesStored(long verticesStored) {
        this.verticesStored += verticesStored;
    }

    public synchronized void incrementPartitionsStored() {
        ++this.partitionsStored;
    }

    public synchronized void finishStoring() {
        this.storingDone = true;
    }

    public synchronized void updateMemory() {
        this.freeMemoryMB = MemoryUtils.freeMemoryMB();
    }

    @ThriftField(value=1)
    public synchronized long getCurrentSuperstep() {
        return this.currentSuperstep;
    }

    @ThriftField(value=2)
    public synchronized long getVerticesLoaded() {
        return this.verticesLoaded;
    }

    @ThriftField(value=3)
    public synchronized int getVertexInputSplitsLoaded() {
        return this.vertexInputSplitsLoaded;
    }

    @ThriftField(value=4)
    public synchronized boolean isLoadingVerticesDone() {
        return this.loadingVerticesDone;
    }

    @ThriftField(value=5)
    public synchronized long getEdgesLoaded() {
        return this.edgesLoaded;
    }

    @ThriftField(value=6)
    public synchronized int getEdgeInputSplitsLoaded() {
        return this.edgeInputSplitsLoaded;
    }

    @ThriftField(value=7)
    public synchronized boolean isLoadingEdgesDone() {
        return this.loadingEdgesDone;
    }

    @ThriftField(value=8)
    public synchronized long getVerticesToCompute() {
        return this.verticesToCompute;
    }

    @ThriftField(value=9)
    public synchronized long getVerticesComputed() {
        return this.verticesComputed;
    }

    @ThriftField(value=10)
    public synchronized int getPartitionsToCompute() {
        return this.partitionsToCompute;
    }

    @ThriftField(value=11)
    public synchronized int getPartitionsComputed() {
        return this.partitionsComputed;
    }

    @ThriftField(value=12)
    public synchronized boolean isComputationDone() {
        return this.computationDone;
    }

    @ThriftField(value=13)
    public synchronized long getVerticesToStore() {
        return this.verticesToStore;
    }

    @ThriftField(value=14)
    public synchronized long getVerticesStored() {
        return this.verticesStored;
    }

    @ThriftField(value=15)
    public synchronized int getPartitionsToStore() {
        return this.partitionsToStore;
    }

    @ThriftField(value=16)
    public synchronized int getPartitionsStored() {
        return this.partitionsStored;
    }

    @ThriftField(value=17)
    public synchronized boolean isStoringDone() {
        return this.storingDone;
    }

    @ThriftField(value=18)
    public synchronized int getTaskId() {
        return this.taskId;
    }

    @ThriftField(value=19)
    public synchronized double getFreeMemoryMB() {
        return this.freeMemoryMB;
    }

    public synchronized boolean isInputSuperstep() {
        return this.currentSuperstep == -1L;
    }

    public synchronized boolean isComputeSuperstep() {
        return this.currentSuperstep >= 0L && this.currentSuperstep < Long.MAX_VALUE;
    }

    public synchronized boolean isOutputSuperstep() {
        return this.currentSuperstep == Long.MAX_VALUE;
    }

    @ThriftField
    public void setCurrentSuperstep(long currentSuperstep) {
        this.currentSuperstep = currentSuperstep;
    }

    @ThriftField
    public void setVerticesLoaded(long verticesLoaded) {
        this.verticesLoaded = verticesLoaded;
    }

    @ThriftField
    public void setVertexInputSplitsLoaded(int vertexInputSplitsLoaded) {
        this.vertexInputSplitsLoaded = vertexInputSplitsLoaded;
    }

    @ThriftField
    public void setLoadingVerticesDone(boolean loadingVerticesDone) {
        this.loadingVerticesDone = loadingVerticesDone;
    }

    @ThriftField
    public void setEdgesLoaded(long edgesLoaded) {
        this.edgesLoaded = edgesLoaded;
    }

    @ThriftField
    public void setEdgeInputSplitsLoaded(int edgeInputSplitsLoaded) {
        this.edgeInputSplitsLoaded = edgeInputSplitsLoaded;
    }

    @ThriftField
    public void setLoadingEdgesDone(boolean loadingEdgesDone) {
        this.loadingEdgesDone = loadingEdgesDone;
    }

    @ThriftField
    public void setVerticesToCompute(long verticesToCompute) {
        this.verticesToCompute = verticesToCompute;
    }

    @ThriftField
    public void setVerticesComputed(long verticesComputed) {
        this.verticesComputed = verticesComputed;
    }

    @ThriftField
    public void setPartitionsToCompute(int partitionsToCompute) {
        this.partitionsToCompute = partitionsToCompute;
    }

    @ThriftField
    public void setPartitionsComputed(int partitionsComputed) {
        this.partitionsComputed = partitionsComputed;
    }

    @ThriftField
    public void setComputationDone(boolean computationDone) {
        this.computationDone = computationDone;
    }

    @ThriftField
    public void setVerticesToStore(long verticesToStore) {
        this.verticesToStore = verticesToStore;
    }

    @ThriftField
    public void setVerticesStored(long verticesStored) {
        this.verticesStored = verticesStored;
    }

    @ThriftField
    public void setPartitionsToStore(int partitionsToStore) {
        this.partitionsToStore = partitionsToStore;
    }

    @ThriftField
    public void setPartitionsStored(int partitionsStored) {
        this.partitionsStored = partitionsStored;
    }

    @ThriftField
    public void setStoringDone(boolean storingDone) {
        this.storingDone = storingDone;
    }

    @ThriftField
    public void setFreeMemoryMB(double freeMemoryMB) {
        this.freeMemoryMB = freeMemoryMB;
    }

    @ThriftField
    public synchronized void setTaskId(int taskId) {
        this.taskId = taskId;
    }
}

