/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.worker;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.requests.SendWorkerToWorkerMessageRequest;
import org.apache.giraph.graph.GraphState;
import org.apache.giraph.worker.WorkerAggregatorDelegator;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;

public abstract class WorkerContext
extends WorkerAggregatorDelegator<WritableComparable, Writable, Writable>
implements Writable {
    private GraphState graphState;
    private CentralizedServiceWorker serviceWorker;
    private List<WorkerInfo> workerList;
    private int myWorkerIndex;

    public void setGraphState(GraphState graphState) {
        this.graphState = graphState;
    }

    public void setupSuperstep(CentralizedServiceWorker<?, ?, ?> serviceWorker) {
        this.serviceWorker = serviceWorker;
        this.workerList = serviceWorker.getWorkerInfoList();
        this.myWorkerIndex = this.workerList.indexOf(serviceWorker.getWorkerInfo());
    }

    public abstract void preApplication() throws InstantiationException, IllegalAccessException;

    public abstract void postApplication();

    public abstract void preSuperstep();

    public int getWorkerCount() {
        return this.workerList.size();
    }

    public int getMyWorkerIndex() {
        return this.myWorkerIndex;
    }

    public List<Writable> getAndClearMessagesFromOtherWorkers() {
        return this.serviceWorker.getServerData().getAndClearCurrentWorkerToWorkerMessages();
    }

    public void sendMessageToWorker(Writable message, int workerIndex) {
        SendWorkerToWorkerMessageRequest request = new SendWorkerToWorkerMessageRequest(message);
        if (workerIndex == this.myWorkerIndex) {
            request.doRequest(this.serviceWorker.getServerData());
        } else {
            this.serviceWorker.getWorkerClient().sendWritableRequest(this.workerList.get(workerIndex).getTaskId(), request);
        }
    }

    public abstract void postSuperstep();

    public long getSuperstep() {
        return this.graphState.getSuperstep();
    }

    public long getTotalNumVertices() {
        return this.graphState.getTotalNumVertices();
    }

    public long getTotalNumEdges() {
        return this.graphState.getTotalNumEdges();
    }

    public Mapper.Context getContext() {
        return this.graphState.getContext();
    }

    public void logToCommandLine(String line) {
        this.serviceWorker.getJobProgressTracker().logInfo(line);
    }

    public void write(DataOutput dataOutput) throws IOException {
    }

    public void readFields(DataInput dataInput) throws IOException {
    }
}

