/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.worker;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.GlobalCommType;
import org.apache.giraph.comm.aggregators.AggregatorUtils;
import org.apache.giraph.comm.aggregators.AllAggregatorServerData;
import org.apache.giraph.comm.aggregators.GlobalCommValueOutputStream;
import org.apache.giraph.comm.aggregators.OwnerAggregatorServerData;
import org.apache.giraph.comm.aggregators.WorkerAggregatorRequestProcessor;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.reducers.ReduceOperation;
import org.apache.giraph.reducers.Reducer;
import org.apache.giraph.utils.UnsafeByteArrayOutputStream;
import org.apache.giraph.utils.UnsafeReusableByteArrayInput;
import org.apache.giraph.utils.WritableUtils;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.giraph.worker.WorkerThreadGlobalCommUsage;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class WorkerAggregatorHandler
implements WorkerThreadGlobalCommUsage {
    private static final Logger LOG = Logger.getLogger(WorkerAggregatorHandler.class);
    private final Map<String, Writable> broadcastedMap = Maps.newHashMap();
    private final Map<String, Reducer<Object, Writable>> reducerMap = Maps.newHashMap();
    private final CentralizedServiceWorker<?, ?, ?> serviceWorker;
    private final Progressable progressable;
    private final int maxBytesPerAggregatorRequest;
    private final ImmutableClassesGiraphConfiguration conf;

    public WorkerAggregatorHandler(CentralizedServiceWorker<?, ?, ?> serviceWorker, ImmutableClassesGiraphConfiguration conf, Progressable progressable) {
        this.serviceWorker = serviceWorker;
        this.progressable = progressable;
        this.conf = conf;
        this.maxBytesPerAggregatorRequest = conf.getInt("giraph.maxBytesPerAggregatorRequest", 0x100000);
    }

    @Override
    public <B extends Writable> B getBroadcast(String name) {
        Writable value = this.broadcastedMap.get(name);
        if (value == null) {
            LOG.warn((Object)("getBroadcast: " + AggregatorUtils.getUnregisteredBroadcastMessage(name, this.broadcastedMap.size() != 0, this.conf)));
        }
        return (B)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reduce(String name, Object value) {
        Reducer<Object, Writable> reducer = this.reducerMap.get(name);
        if (reducer != null) {
            this.progressable.progress();
            Reducer<Object, Writable> reducer2 = reducer;
            synchronized (reducer2) {
                reducer.reduceSingle(value);
            }
        } else {
            throw new IllegalStateException("reduce: " + AggregatorUtils.getUnregisteredReducerMessage(name, this.reducerMap.size() != 0, this.conf));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reducePartial(String name, Writable valueToReduce) {
        Reducer<Object, Writable> reducer = this.reducerMap.get(name);
        if (reducer != null) {
            this.progressable.progress();
            Reducer<Object, Writable> reducer2 = reducer;
            synchronized (reducer2) {
                reducer.reducePartial(valueToReduce);
            }
        } else {
            throw new IllegalStateException("reduce: " + AggregatorUtils.getUnregisteredReducerMessage(name, this.reducerMap.size() != 0, this.conf));
        }
    }

    public void prepareSuperstep(WorkerAggregatorRequestProcessor requestProcessor) {
        this.broadcastedMap.clear();
        this.reducerMap.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"prepareSuperstep: Start preparing aggregators");
        }
        AllAggregatorServerData allGlobalCommData = this.serviceWorker.getServerData().getAllAggregatorData();
        Iterable<byte[]> dataToDistribute = allGlobalCommData.getDataFromMasterWhenReady(this.serviceWorker.getMasterInfo());
        try {
            requestProcessor.distributeReducedValues(dataToDistribute);
        }
        catch (IOException e) {
            throw new IllegalStateException("prepareSuperstep: IOException occurred while trying to distribute aggregators", e);
        }
        allGlobalCommData.fillNextSuperstepMapsWhenReady(this.getOtherWorkerIdsSet(), this.broadcastedMap, this.reducerMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"prepareSuperstep: Aggregators prepared");
        }
    }

    public void finishSuperstep(WorkerAggregatorRequestProcessor requestProcessor) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"finishSuperstep: Start gathering aggregators, workers will send their aggregated values once they are done with superstep computation");
        }
        OwnerAggregatorServerData ownerGlobalCommData = this.serviceWorker.getServerData().getOwnerAggregatorData();
        for (Map.Entry<String, Reducer<Object, Writable>> entry : this.reducerMap.entrySet()) {
            try {
                boolean sent = requestProcessor.sendReducedValue(entry.getKey(), entry.getValue().getCurrentValue());
                if (!sent) {
                    ownerGlobalCommData.reduce(entry.getKey(), entry.getValue().getCurrentValue());
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("finishSuperstep: IOException occurred while sending aggregator " + entry.getKey() + " to its owner", e);
            }
            this.progressable.progress();
        }
        try {
            requestProcessor.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("finishSuperstep: IOException occurred while sending aggregators to owners", e);
        }
        Iterable<Map.Entry<String, Writable>> myReducedValues = ownerGlobalCommData.getMyReducedValuesWhenReady(this.getOtherWorkerIdsSet());
        GlobalCommValueOutputStream globalOutput = new GlobalCommValueOutputStream(false);
        for (Map.Entry<String, Writable> entry : myReducedValues) {
            try {
                int currentSize = globalOutput.addValue(entry.getKey(), GlobalCommType.REDUCED_VALUE, entry.getValue());
                if (currentSize > this.maxBytesPerAggregatorRequest) {
                    requestProcessor.sendReducedValuesToMaster(globalOutput.flush());
                }
                this.progressable.progress();
            }
            catch (IOException e) {
                throw new IllegalStateException("finishSuperstep: IOException occurred while writing aggregator " + entry.getKey(), e);
            }
        }
        try {
            requestProcessor.sendReducedValuesToMaster(globalOutput.flush());
        }
        catch (IOException e) {
            throw new IllegalStateException("finishSuperstep: IOException occured while sending aggregators to master", e);
        }
        this.serviceWorker.getWorkerClient().waitAllRequests();
        ownerGlobalCommData.reset();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"finishSuperstep: Aggregators finished");
        }
    }

    public WorkerThreadGlobalCommUsage newThreadAggregatorUsage() {
        if (AggregatorUtils.useThreadLocalAggregators(this.conf)) {
            return new ThreadLocalWorkerGlobalCommUsage();
        }
        return this;
    }

    @Override
    public void finishThreadComputation() {
    }

    public Set<Integer> getOtherWorkerIdsSet() {
        HashSet otherWorkers = Sets.newHashSetWithExpectedSize((int)this.serviceWorker.getWorkerInfoList().size());
        for (WorkerInfo workerInfo : this.serviceWorker.getWorkerInfoList()) {
            if (workerInfo.getTaskId() == this.serviceWorker.getWorkerInfo().getTaskId()) continue;
            otherWorkers.add(workerInfo.getTaskId());
        }
        return otherWorkers;
    }

    public class ThreadLocalWorkerGlobalCommUsage
    implements WorkerThreadGlobalCommUsage {
        private final Map<String, Reducer<Object, Writable>> threadReducerMap;

        public ThreadLocalWorkerGlobalCommUsage() {
            this.threadReducerMap = Maps.newHashMapWithExpectedSize((int)WorkerAggregatorHandler.this.reducerMap.size());
            UnsafeByteArrayOutputStream out = new UnsafeByteArrayOutputStream();
            UnsafeReusableByteArrayInput in = new UnsafeReusableByteArrayInput();
            for (Map.Entry entry : WorkerAggregatorHandler.this.reducerMap.entrySet()) {
                ReduceOperation globalReduceOp = ((Reducer)entry.getValue()).getReduceOp();
                ReduceOperation threadLocalCopy = WritableUtils.createCopy(out, in, globalReduceOp, WorkerAggregatorHandler.this.conf);
                this.threadReducerMap.put((String)entry.getKey(), new Reducer(threadLocalCopy));
            }
        }

        @Override
        public void reduce(String name, Object value) {
            Reducer<Object, Writable> reducer = this.threadReducerMap.get(name);
            if (reducer == null) {
                throw new IllegalStateException("reduce: " + AggregatorUtils.getUnregisteredAggregatorMessage(name, this.threadReducerMap.size() != 0, WorkerAggregatorHandler.this.conf));
            }
            WorkerAggregatorHandler.this.progressable.progress();
            reducer.reduceSingle(value);
        }

        @Override
        public <B extends Writable> B getBroadcast(String name) {
            return WorkerAggregatorHandler.this.getBroadcast(name);
        }

        @Override
        public void finishThreadComputation() {
            for (Map.Entry<String, Reducer<Object, Writable>> entry : this.threadReducerMap.entrySet()) {
                WorkerAggregatorHandler.this.reducePartial(entry.getKey(), entry.getValue().getCurrentValue());
            }
        }
    }
}

