/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.worker;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexEdgeCount;
import org.apache.giraph.io.GiraphInputFormat;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.filters.VertexInputFilter;
import org.apache.giraph.mapping.translate.TranslateEdge;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.utils.LoggerUtils;
import org.apache.giraph.utils.MemoryUtils;
import org.apache.giraph.worker.BspServiceWorker;
import org.apache.giraph.worker.InputSplitsCallable;
import org.apache.giraph.worker.InputSplitsHandler;
import org.apache.giraph.worker.WorkerProgress;
import org.apache.giraph.worker.WorkerThreadGlobalCommUsage;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class VertexInputSplitsCallable<I extends WritableComparable, V extends Writable, E extends Writable>
extends InputSplitsCallable<I, V, E> {
    public static final int VERTICES_UPDATE_PERIOD = 250000;
    public static final int VERTICES_FILTERED_UPDATE_PERIOD = 2500;
    private static final Logger LOG = Logger.getLogger(VertexInputSplitsCallable.class);
    private final VertexInputFormat<I, V, E> vertexInputFormat;
    private final long inputSplitMaxVertices;
    private final BspServiceWorker<I, V, E> bspServiceWorker;
    private final VertexInputFilter<I, V, E> vertexInputFilter;
    private final boolean canEmbedInIds;
    private final boolean reuseEdgeObjects;
    private final TranslateEdge<I, E> translateEdge;
    private final Meter totalVerticesMeter;
    private final Counter totalVerticesFilteredCounter;
    private final Meter totalEdgesMeter;

    public VertexInputSplitsCallable(VertexInputFormat<I, V, E> vertexInputFormat, Mapper.Context context, ImmutableClassesGiraphConfiguration<I, V, E> configuration, BspServiceWorker<I, V, E> bspServiceWorker, InputSplitsHandler splitsHandler, ZooKeeperExt zooKeeperExt) {
        super(context, configuration, bspServiceWorker, splitsHandler, zooKeeperExt);
        this.vertexInputFormat = vertexInputFormat;
        this.inputSplitMaxVertices = configuration.getInputSplitMaxVertices();
        this.bspServiceWorker = bspServiceWorker;
        this.vertexInputFilter = configuration.getVertexInputFilter();
        this.reuseEdgeObjects = configuration.reuseEdgeObjects();
        this.canEmbedInIds = bspServiceWorker.getLocalData().getMappingStoreOps() != null && bspServiceWorker.getLocalData().getMappingStoreOps().hasEmbedding();
        this.translateEdge = bspServiceWorker.getTranslateEdge();
        this.totalVerticesMeter = VertexInputSplitsCallable.getTotalVerticesLoadedMeter();
        this.totalVerticesFilteredCounter = VertexInputSplitsCallable.getTotalVerticesFilteredCounter();
        this.totalEdgesMeter = VertexInputSplitsCallable.getTotalEdgesLoadedMeter();
    }

    @Override
    public GiraphInputFormat getInputFormat() {
        return this.vertexInputFormat;
    }

    @Override
    protected VertexEdgeCount readInputSplit(InputSplit inputSplit) throws IOException, InterruptedException {
        VertexReader<I, V, E> vertexReader = this.vertexInputFormat.createVertexReader(inputSplit, (TaskAttemptContext)this.context);
        vertexReader.setConf(this.configuration);
        WorkerThreadGlobalCommUsage globalCommUsage = this.bspServiceWorker.getAggregatorHandler().newThreadAggregatorUsage();
        vertexReader.initialize(inputSplit, (TaskAttemptContext)this.context);
        vertexReader.setWorkerGlobalCommUsage(globalCommUsage);
        long inputSplitVerticesLoaded = 0L;
        long inputSplitVerticesFiltered = 0L;
        long edgesSinceLastUpdate = 0L;
        long inputSplitEdgesLoaded = 0L;
        while (vertexReader.nextVertex()) {
            Vertex readerVertex = vertexReader.getCurrentVertex();
            if (readerVertex.getId() == null) {
                throw new IllegalArgumentException("readInputSplit: Vertex reader returned a vertex without an id!  - " + readerVertex);
            }
            if (this.canEmbedInIds) {
                this.bspServiceWorker.getLocalData().getMappingStoreOps().embedTargetInfo(readerVertex.getId());
            }
            if (readerVertex.getValue() == null) {
                readerVertex.setValue(this.configuration.createVertexValue());
            }
            readerVertex.setConf(this.configuration);
            ++inputSplitVerticesLoaded;
            if (this.vertexInputFilter.dropVertex(readerVertex)) {
                if (++inputSplitVerticesFiltered % 2500L != 0L) continue;
                this.totalVerticesFilteredCounter.inc(inputSplitVerticesFiltered);
                inputSplitVerticesFiltered = 0L;
                continue;
            }
            if (this.translateEdge != null && readerVertex.getEdges() != null && readerVertex.getNumEdges() > 0) {
                OutEdges<I, E> vertexOutEdges = this.configuration.createAndInitializeOutEdges(readerVertex.getNumEdges());
                for (Edge<I, E> edge : readerVertex.getEdges()) {
                    if (this.reuseEdgeObjects) {
                        this.bspServiceWorker.getLocalData().getMappingStoreOps().embedTargetInfo(edge.getTargetVertexId());
                        vertexOutEdges.add(edge);
                        continue;
                    }
                    vertexOutEdges.add(this.configuration.createEdge(this.translateEdge, edge));
                }
                readerVertex.setEdges(vertexOutEdges);
            }
            PartitionOwner partitionOwner = this.bspServiceWorker.getVertexPartitionOwner(readerVertex.getId());
            this.workerClientRequestProcessor.sendVertexRequest(partitionOwner, readerVertex);
            edgesSinceLastUpdate += (long)readerVertex.getNumEdges();
            if (inputSplitVerticesLoaded % 250000L == 0L) {
                this.totalVerticesMeter.mark(250000L);
                WorkerProgress.get().addVerticesLoaded(250000L);
                this.totalEdgesMeter.mark(edgesSinceLastUpdate);
                inputSplitEdgesLoaded += edgesSinceLastUpdate;
                edgesSinceLastUpdate = 0L;
                LoggerUtils.setStatusAndLog((TaskAttemptContext)this.context, LOG, Level.INFO, "readVertexInputSplit: Loaded " + this.totalVerticesMeter.count() + " vertices at " + this.totalVerticesMeter.meanRate() + " vertices/sec " + this.totalEdgesMeter.count() + " edges at " + this.totalEdgesMeter.meanRate() + " edges/sec " + MemoryUtils.getRuntimeMemoryStats());
            }
            if (this.inputSplitMaxVertices <= 0L || inputSplitVerticesLoaded < this.inputSplitMaxVertices) continue;
            if (!LOG.isInfoEnabled()) break;
            LOG.info((Object)("readInputSplit: Leaving the input split early, reached maximum vertices " + inputSplitVerticesLoaded));
            break;
        }
        this.totalVerticesMeter.mark(inputSplitVerticesLoaded % 250000L);
        this.totalEdgesMeter.mark(edgesSinceLastUpdate);
        this.totalVerticesFilteredCounter.inc(inputSplitVerticesFiltered);
        vertexReader.close();
        WorkerProgress.get().addVerticesLoaded(inputSplitVerticesLoaded % 250000L);
        WorkerProgress.get().incrementVertexInputSplitsLoaded();
        return new VertexEdgeCount(inputSplitVerticesLoaded, inputSplitEdgesLoaded + edgesSinceLastUpdate);
    }
}

