/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.worker;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.io.GiraphInputFormat;
import org.apache.giraph.io.MappingInputFormat;
import org.apache.giraph.io.MappingReader;
import org.apache.giraph.mapping.MappingEntry;
import org.apache.giraph.mapping.MappingStore;
import org.apache.giraph.worker.BspServiceWorker;
import org.apache.giraph.worker.FullInputSplitCallable;
import org.apache.giraph.worker.InputSplitPathOrganizer;
import org.apache.giraph.worker.WorkerThreadGlobalCommUsage;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class MappingInputSplitsCallable<I extends WritableComparable, V extends Writable, E extends Writable, B extends Writable>
extends FullInputSplitCallable<I, V, E> {
    private final MappingInputFormat<I, V, E, B> mappingInputFormat;
    private final BspServiceWorker<I, V, E> bspServiceWorker;

    public MappingInputSplitsCallable(MappingInputFormat<I, V, E, B> mappingInputFormat, InputSplitPathOrganizer splitOrganizer, Mapper.Context context, ImmutableClassesGiraphConfiguration<I, V, E> configuration, ZooKeeperExt zooKeeperExt, AtomicInteger currentIndex, BspServiceWorker<I, V, E> bspServiceWorker) {
        super(splitOrganizer, context, configuration, zooKeeperExt, currentIndex);
        this.mappingInputFormat = mappingInputFormat;
        this.bspServiceWorker = bspServiceWorker;
    }

    @Override
    public GiraphInputFormat getInputFormat() {
        return this.mappingInputFormat;
    }

    @Override
    protected Integer readInputSplit(InputSplit inputSplit) throws IOException, InterruptedException {
        MappingReader<I, V, E, B> mappingReader = this.mappingInputFormat.createMappingReader(inputSplit, (TaskAttemptContext)this.context);
        mappingReader.setConf(this.configuration);
        WorkerThreadGlobalCommUsage globalCommUsage = this.bspServiceWorker.getAggregatorHandler().newThreadAggregatorUsage();
        mappingReader.initialize(inputSplit, (TaskAttemptContext)this.context);
        mappingReader.setWorkerGlobalCommUsage(globalCommUsage);
        int entriesLoaded = 0;
        MappingStore<I, Writable> mappingStore = this.bspServiceWorker.getLocalData().getMappingStore();
        while (mappingReader.nextEntry()) {
            MappingEntry<I, B> entry = mappingReader.getCurrentEntry();
            ++entriesLoaded;
            mappingStore.addEntry(entry.getVertexId(), (Writable)entry.getMappingTarget());
        }
        return entriesLoaded;
    }
}

