/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.worker;

import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.mapping.MappingStore;
import org.apache.giraph.mapping.MappingStoreOps;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class LocalData<I extends WritableComparable, V extends Writable, E extends Writable, B extends Writable>
extends DefaultImmutableClassesGiraphConfigurable<I, V, E> {
    private static final Logger LOG = Logger.getLogger(LocalData.class);
    private MappingStore<I, B> mappingStore;
    private MappingStoreOps<I, B> mappingStoreOps;

    public LocalData(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        this.setConf(conf);
        this.mappingStore = this.getConf().createMappingStore();
        if (this.mappingStore != null) {
            this.mappingStore.initialize();
        }
        this.mappingStoreOps = this.getConf().createMappingStoreOps();
        if (this.mappingStoreOps != null) {
            this.mappingStoreOps.initialize(this.mappingStore);
        }
    }

    public MappingStore<I, B> getMappingStore() {
        return this.mappingStore;
    }

    public MappingStoreOps<I, B> getMappingStoreOps() {
        return this.mappingStoreOps;
    }

    public void removeMappingStoreIfPossible() {
        if (this.mappingStoreOps != null && this.mappingStoreOps.hasEmbedding()) {
            this.mappingStore = null;
        }
    }

    public void printStats() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("MappingStore has : " + this.mappingStore.getStats() + " entries"));
        }
    }
}

