/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.worker;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.giraph.worker.InputSplitPathOrganizer;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class InputSplitsHandler
implements Watcher {
    private static final Logger LOG = Logger.getLogger(InputSplitsHandler.class);
    private final List<String> pathList;
    private final AtomicInteger currentIndex;
    private final ZooKeeperExt zooKeeper;
    private final Mapper.Context context;
    private final String inputSplitReservedNode;
    private final String inputSplitFinishedNode;

    public InputSplitsHandler(InputSplitPathOrganizer splitOrganizer, ZooKeeperExt zooKeeper, Mapper.Context context, String inputSplitReservedNode, String inputSplitFinishedNode) {
        this.pathList = Lists.newArrayList(splitOrganizer.getPathList());
        this.currentIndex = new AtomicInteger(0);
        this.zooKeeper = zooKeeper;
        this.context = context;
        this.inputSplitReservedNode = inputSplitReservedNode;
        this.inputSplitFinishedNode = inputSplitFinishedNode;
    }

    /*
     * Loose catch block
     */
    public String reserveInputSplit() throws KeeperException, InterruptedException {
        while (true) {
            int splitToTry;
            if ((splitToTry = this.currentIndex.getAndIncrement()) >= this.pathList.size()) {
                return null;
            }
            String nextSplitToClaim = this.pathList.get(splitToTry);
            this.context.progress();
            String tmpInputSplitReservedPath = nextSplitToClaim + this.inputSplitReservedNode;
            Stat reservedStat = this.zooKeeper.exists(tmpInputSplitReservedPath, this);
            if (reservedStat != null) continue;
            try {
                this.zooKeeper.createExt(tmpInputSplitReservedPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, false);
                String reservedInputSplitPath = nextSplitToClaim;
                if (LOG.isInfoEnabled()) {
                    float percentFinished = (float)splitToTry * 100.0f / (float)this.pathList.size();
                    LOG.info((Object)("reserveInputSplit: Reserved input split path " + reservedInputSplitPath + ", overall roughly " + percentFinished + "% input splits reserved"));
                }
                return reservedInputSplitPath;
            }
            catch (KeeperException.NodeExistsException e) {
                LOG.info((Object)("reserveInputSplit: Couldn't reserve (already reserved) inputSplit at " + tmpInputSplitReservedPath));
                continue;
            }
            catch (KeeperException e) {
                throw new IllegalStateException("reserveInputSplit: KeeperException on reserve", e);
            }
            break;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("reserveInputSplit: InterruptedException on reserve", e);
        }
    }

    public void markInputSplitPathFinished(String inputSplitPath) {
        String inputSplitFinishedPath = inputSplitPath + this.inputSplitFinishedNode;
        try {
            this.zooKeeper.createExt(inputSplitFinishedPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.warn((Object)("markInputSplitPathFinished: " + inputSplitFinishedPath + " already exists!"));
        }
        catch (KeeperException e) {
            throw new IllegalStateException("markInputSplitPathFinished: KeeperException on " + inputSplitFinishedPath, e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("markInputSplitPathFinished: InterruptedException on " + inputSplitFinishedPath, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent event) {
        if (event.getPath() == null) {
            LOG.warn((Object)("process: Problem with zookeeper, got event with path null, state " + event.getState() + ", event type " + event.getType()));
            return;
        }
        if (event.getPath().endsWith(this.inputSplitReservedNode) && event.getType() == Watcher.Event.EventType.NodeDeleted) {
            List<String> list = this.pathList;
            synchronized (list) {
                String split = event.getPath();
                split = split.substring(0, split.indexOf(this.inputSplitReservedNode));
                this.pathList.add(split);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("process: Input split " + split + " lost reservation"));
                }
            }
        }
    }
}

