/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.worker;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.util.PercentGauge;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.giraph.comm.WorkerClientRequestProcessor;
import org.apache.giraph.comm.netty.NettyWorkerClientRequestProcessor;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.VertexEdgeCount;
import org.apache.giraph.io.GiraphInputFormat;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.giraph.metrics.GiraphMetricsRegistry;
import org.apache.giraph.metrics.MeterDesc;
import org.apache.giraph.time.SystemTime;
import org.apache.giraph.time.Time;
import org.apache.giraph.time.Times;
import org.apache.giraph.worker.BspServiceWorker;
import org.apache.giraph.worker.InputSplitsHandler;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;

public abstract class InputSplitsCallable<I extends WritableComparable, V extends Writable, E extends Writable>
implements Callable<VertexEdgeCount> {
    private static final Logger LOG = Logger.getLogger(InputSplitsCallable.class);
    private static final Time TIME = SystemTime.get();
    protected final ImmutableClassesGiraphConfiguration<I, V, E> configuration;
    protected final Mapper.Context context;
    protected final WorkerClientRequestProcessor<I, V, E> workerClientRequestProcessor;
    private final InputSplitsHandler splitsHandler;
    private final ZooKeeperExt zooKeeperExt;
    private final long startNanos = TIME.getNanoseconds();
    private final boolean useLocality;

    public InputSplitsCallable(Mapper.Context context, ImmutableClassesGiraphConfiguration<I, V, E> configuration, BspServiceWorker<I, V, E> bspServiceWorker, InputSplitsHandler splitsHandler, ZooKeeperExt zooKeeperExt) {
        this.zooKeeperExt = zooKeeperExt;
        this.context = context;
        this.workerClientRequestProcessor = new NettyWorkerClientRequestProcessor<I, V, E>(context, configuration, bspServiceWorker);
        this.useLocality = configuration.useInputSplitLocality();
        this.splitsHandler = splitsHandler;
        this.configuration = configuration;
    }

    public abstract GiraphInputFormat getInputFormat();

    public static Meter getTotalEdgesLoadedMeter() {
        return GiraphMetrics.get().perJobRequired().getMeter(MeterDesc.EDGES_LOADED);
    }

    public static Counter getTotalEdgesFilteredCounter() {
        return GiraphMetrics.get().perJobRequired().getCounter("edges-filtered");
    }

    public static Meter getTotalVerticesLoadedMeter() {
        return GiraphMetrics.get().perJobRequired().getMeter(MeterDesc.VERTICES_LOADED);
    }

    public static Counter getTotalVerticesFilteredCounter() {
        return GiraphMetrics.get().perJobRequired().getCounter("vertices-filtered");
    }

    public static void initMetrics() {
        GiraphMetricsRegistry metrics = GiraphMetrics.get().perJobRequired();
        final Counter edgesFiltered = InputSplitsCallable.getTotalEdgesFilteredCounter();
        final Meter edgesLoaded = InputSplitsCallable.getTotalEdgesLoadedMeter();
        metrics.getGauge("edges-filtered-pct", new PercentGauge(){

            protected double getNumerator() {
                return edgesFiltered.count();
            }

            protected double getDenominator() {
                return edgesLoaded.count();
            }
        });
        final Counter verticesFiltered = InputSplitsCallable.getTotalVerticesFilteredCounter();
        final Meter verticesLoaded = InputSplitsCallable.getTotalVerticesLoadedMeter();
        metrics.getGauge("vertices-filtered-pct", new PercentGauge(){

            protected double getNumerator() {
                return verticesFiltered.count();
            }

            protected double getDenominator() {
                return verticesLoaded.count();
            }
        });
    }

    protected abstract VertexEdgeCount readInputSplit(InputSplit var1) throws IOException, InterruptedException;

    @Override
    public VertexEdgeCount call() {
        VertexEdgeCount vertexEdgeCount = new VertexEdgeCount();
        int inputSplitsProcessed = 0;
        try {
            String inputSplitPath;
            while ((inputSplitPath = this.splitsHandler.reserveInputSplit()) != null) {
                vertexEdgeCount = vertexEdgeCount.incrVertexEdgeCount(this.loadInputSplit(inputSplitPath));
                this.context.progress();
                ++inputSplitsProcessed;
            }
        }
        catch (KeeperException e) {
            throw new IllegalStateException("call: KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("call: InterruptedException", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("call: IOException", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("call: ClassNotFoundException", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("call: InstantiationException", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("call: IllegalAccessException", e);
        }
        if (LOG.isInfoEnabled()) {
            float seconds = (float)Times.getNanosSince(TIME, this.startNanos) / 1.0E9f;
            float verticesPerSecond = (float)vertexEdgeCount.getVertexCount() / seconds;
            float edgesPerSecond = (float)vertexEdgeCount.getEdgeCount() / seconds;
            LOG.info((Object)("call: Loaded " + inputSplitsProcessed + " " + "input splits in " + seconds + " secs, " + vertexEdgeCount + " " + verticesPerSecond + " vertices/sec, " + edgesPerSecond + " edges/sec"));
        }
        try {
            this.workerClientRequestProcessor.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("call: Flushing failed.", e);
        }
        return vertexEdgeCount;
    }

    private VertexEdgeCount loadInputSplit(String inputSplitPath) throws IOException, ClassNotFoundException, InterruptedException, InstantiationException, IllegalAccessException {
        InputSplit inputSplit = this.getInputSplit(inputSplitPath);
        VertexEdgeCount vertexEdgeCount = this.readInputSplit(inputSplit);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("loadFromInputSplit: Finished loading " + inputSplitPath + " " + vertexEdgeCount));
        }
        this.splitsHandler.markInputSplitPathFinished(inputSplitPath);
        return vertexEdgeCount;
    }

    protected InputSplit getInputSplit(String inputSplitPath) throws IOException, ClassNotFoundException {
        byte[] splitList;
        try {
            splitList = this.zooKeeperExt.getData(inputSplitPath, false, null);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("getInputSplit: KeeperException on " + inputSplitPath, e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("getInputSplit: IllegalStateException on " + inputSplitPath, e);
        }
        this.context.progress();
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(splitList));
        if (this.useLocality) {
            Text.readString((DataInput)inputStream);
        }
        InputSplit inputSplit = this.getInputFormat().readInputSplit(inputStream);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("getInputSplit: Reserved " + inputSplitPath + " from ZooKeeper and got input split '" + inputSplit.toString() + "'"));
        }
        return inputSplit;
    }
}

